/*
 * Decompiled with CFR 0.152.
 */
package com.knuddels.jtokkit;

import com.knuddels.jtokkit.ByteArrayWrapper;
import com.knuddels.jtokkit.TokenEncoder;
import com.knuddels.jtokkit.api.IntArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

final class TokenEncoderLarge {
    TokenEncoderLarge() {
    }

    static int calculateTokensLarge(TokenEncoder tokenEncoder, int maxTokenCount, boolean keepEncodings, IntArrayList out, ByteArrayWrapper match) {
        TreeMap<Integer, LinkedHashMap> rankMap = new TreeMap<Integer, LinkedHashMap>();
        RankNode prev = null;
        for (int i = 0; i < match.length() + 1; ++i) {
            int rank = tokenEncoder.encode(match, i, i + 2);
            RankNode node = new RankNode(rank, i, prev);
            if (prev != null) {
                prev.next = node;
            }
            prev = node;
            rankMap.computeIfAbsent(rank, k -> new LinkedHashMap()).put(i, node);
        }
        assert (rankMap.containsKey(0x7FFFFFFE));
        int tokenCount = match.length();
        while (tokenCount > 2 && rankMap.size() > 1) {
            Iterator it = ((LinkedHashMap)rankMap.pollFirstEntry().getValue()).values().iterator();
            while (it.hasNext()) {
                int newRank;
                RankNode minNode = (RankNode)it.next();
                int minRank = minNode.rank;
                assert (minRank != 0x7FFFFFFE);
                RankNode previousNode = minNode.prev;
                RankNode nextNode = minNode.next;
                RankNode nextNextNode = nextNode.next;
                RankNode nextNextNextNode = nextNextNode.next;
                if (previousNode != null && previousNode.rank != (newRank = tokenEncoder.encode(match, previousNode.index, nextNextNode.index))) {
                    assert (previousNode.rank != minRank);
                    TokenEncoderLarge.removeNode((Map)rankMap.get(previousNode.rank), rankMap, previousNode);
                    previousNode.rank = newRank;
                    rankMap.computeIfAbsent(newRank, k -> new LinkedHashMap()).put(previousNode.index, previousNode);
                }
                minNode.rank = newRank = tokenEncoder.encode(match, minNode.index, nextNextNextNode != null ? nextNextNextNode.index : Integer.MAX_VALUE);
                rankMap.computeIfAbsent(newRank, k -> new LinkedHashMap()).put(minNode.index, minNode);
                minNode.next = nextNextNode;
                nextNextNode.prev = minNode;
                if (nextNode.rank != 0x7FFFFFFE) {
                    if (nextNode.rank != minRank) {
                        TokenEncoderLarge.removeNode((Map)rankMap.get(nextNode.rank), rankMap, nextNode);
                    } else {
                        it.next();
                    }
                }
                --tokenCount;
            }
        }
        if (keepEncodings) {
            RankNode head = (RankNode)((LinkedHashMap)rankMap.get(0x7FFFFFFE)).get(0);
            while (head.next != null && out.size() < maxTokenCount) {
                int token = tokenEncoder.encode(match, head.index, head.next.index);
                assert (token != 0x7FFFFFFE) : "Token should not be MAX_RANK";
                out.add(token);
                head = head.next;
            }
        }
        return tokenCount;
    }

    static void removeNode(Map<Integer, RankNode> nodeMap, Map<Integer, ? extends Map<Integer, RankNode>> rankMap, RankNode node) {
        if (Objects.requireNonNull(nodeMap).size() == 1) {
            assert (nodeMap.containsKey(node.index));
            rankMap.remove(node.rank);
        } else {
            nodeMap.remove(node.index);
        }
    }

    private static class RankNode {
        int rank;
        int index;
        RankNode prev;
        RankNode next;

        RankNode(int rank, int index, RankNode prev) {
            this.rank = rank;
            this.index = index;
            this.prev = prev;
        }

        public String toString() {
            return "RankNode{rank=" + this.rank + ", index=" + this.index + '}';
        }
    }
}

