/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common;

import com.google.gson.JsonObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.storage.model.ColumnName;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.model.ModelInstaller;
import org.apache.skywalking.oap.server.core.storage.model.SQLDatabaseExtension;
import org.apache.skywalking.oap.server.core.storage.model.SQLDatabaseModelExtension;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLBuilder;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.TableMetaInfo;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCTableInstaller
extends ModelInstaller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCTableInstaller.class);
    public static final String ID_COLUMN = "id";
    public static final String TABLE_COLUMN = "table_name";

    public JDBCTableInstaller(Client client, ModuleManager moduleManager) {
        super(client, moduleManager);
    }

    public ModelInstaller.InstallInfo isExists(Model model) {
        InstallInfoJDBC installInfo = new InstallInfoJDBC(model);
        TableMetaInfo.addModel(model);
        String table = TableHelper.getLatestTableForWrite(model);
        installInfo.setTableName(table);
        JDBCClient jdbcClient = (JDBCClient)this.client;
        if (!jdbcClient.tableExists(table)) {
            installInfo.setAllExist(false);
            return installInfo;
        }
        Set<String> databaseColumns = this.getDatabaseColumns(table);
        boolean isAnyColumnNotCreated = model.getColumns().stream().map(ModelColumn::getColumnName).map(ColumnName::getStorageName).anyMatch(Predicate.not(databaseColumns::contains));
        installInfo.setAllColumnsExist(isAnyColumnNotCreated);
        installInfo.setAllExist(!isAnyColumnNotCreated);
        return installInfo;
    }

    public void createTable(Model model) {
        long dayTimeBucket = TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Day);
        this.createTable(model, dayTimeBucket);
    }

    public void createTable(Model model, long timeBucket) {
        String table = TableHelper.getTable(model, timeBucket);
        this.createOrUpdateTable(table, model.getColumns(), false);
        this.createOrUpdateTableIndexes(table, model.getColumns(), false);
        this.createAdditionalTable(model, timeBucket);
    }

    public String getColumnDefinition(ModelColumn column) {
        return this.getColumnDefinition(column, column.getType(), column.getGenericType());
    }

    protected String getColumnDefinition(ModelColumn column, Class<?> type, Type genericType) {
        String storageName = column.getColumnName().getStorageName();
        if (Integer.class.equals(type) || Integer.TYPE.equals(type) || Layer.class.equals(type)) {
            return storageName + " INT";
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return storageName + " BIGINT";
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return storageName + " DOUBLE";
        }
        if (String.class.equals(type)) {
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        if (StorageDataComplexObject.class.isAssignableFrom(type)) {
            return storageName + " VARCHAR(20000)";
        }
        if (byte[].class.equals(type)) {
            return storageName + " MEDIUMTEXT";
        }
        if (JsonObject.class.equals(type)) {
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        if (List.class.isAssignableFrom(type)) {
            Type elementType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            return this.getColumnDefinition(column, (Class)elementType, elementType);
        }
        throw new IllegalArgumentException("Unsupported data type: " + type.getName());
    }

    public void createOrUpdateTableIndexes(String table, List<ModelColumn> columns, boolean isAdditionalTable) throws SQLException {
        String index;
        JDBCClient jdbcClient = (JDBCClient)this.client;
        if (isAdditionalTable && !jdbcClient.indexExists(table, index = "idx_" + Math.abs((table + "_id").hashCode()))) {
            this.executeSQL(new SQLBuilder("CREATE INDEX ").append(index).append(" ON ").append(table).append("(").append(ID_COLUMN).append(")"));
        }
        if (!isAdditionalTable && !jdbcClient.indexExists(table, index = "idx_" + Math.abs((table + "_table_name").hashCode()))) {
            this.executeSQL(new SQLBuilder("CREATE INDEX ").append(index).append(" ON ").append(table).append("(").append(TABLE_COLUMN).append(")"));
        }
        List columnsMissingIndex = columns.stream().filter(ModelColumn::shouldIndex).filter(it -> it.getLength() < 256).map(ModelColumn::getColumnName).map(ColumnName::getStorageName).collect(Collectors.toList());
        for (String column : columnsMissingIndex) {
            String index2 = "idx_" + Math.abs((table + "_" + column).hashCode());
            if (jdbcClient.indexExists(table, index2)) continue;
            this.executeSQL(new SQLBuilder("CREATE INDEX ").append(index2).append(" ON ").append(table).append("(").append(column).append(")"));
        }
        Set columnNames = columns.stream().map(ModelColumn::getColumnName).map(ColumnName::getStorageName).collect(Collectors.toSet());
        for (ModelColumn modelColumn : columns) {
            for (SQLDatabaseExtension.MultiColumnsIndex compositeIndex : modelColumn.getSqlDatabaseExtension().getIndices()) {
                String index3;
                List<String> multiColumns = Arrays.asList(compositeIndex.getColumns());
                if (isAdditionalTable && !columnNames.containsAll(multiColumns) || jdbcClient.indexExists(table, index3 = "idx_" + Math.abs((table + "_" + String.join((CharSequence)"_", multiColumns)).hashCode()))) continue;
                this.executeSQL(new SQLBuilder("CREATE INDEX ").append(index3).append(" ON ").append(table).append(multiColumns.stream().collect(Collectors.joining(", ", " (", ")"))));
            }
        }
    }

    public void executeSQL(SQLBuilder sql) throws SQLException {
        JDBCClient c = (JDBCClient)this.client;
        c.execute(sql.toString());
    }

    public void createAdditionalTable(Model model, long timeBucket) throws SQLException {
        Map additionalTables = model.getSqlDBModelExtension().getAdditionalTables();
        for (SQLDatabaseModelExtension.AdditionalTable table : additionalTables.values()) {
            String tableName = TableHelper.getTable(table.getName(), timeBucket);
            this.createOrUpdateTable(tableName, table.getColumns(), true);
            this.createOrUpdateTableIndexes(tableName, table.getColumns(), true);
        }
    }

    public void createOrUpdateTable(String table, List<ModelColumn> columns, boolean isAdditionalTable) {
        ArrayList<ModelColumn> columnsToBeAdded = new ArrayList<ModelColumn>(columns);
        Set<String> existingColumns = this.getDatabaseColumns(table);
        columnsToBeAdded.removeIf(it -> existingColumns.contains(it.getColumnName().getStorageName()));
        JDBCClient jdbcClient = (JDBCClient)this.client;
        if (!jdbcClient.tableExists(table)) {
            this.createTable(table, columnsToBeAdded, isAdditionalTable);
        } else {
            this.updateTable(table, columnsToBeAdded);
        }
    }

    protected Set<String> getDatabaseColumns(String table) throws SQLException {
        JDBCClient jdbcClient = (JDBCClient)this.client;
        return jdbcClient.getTableColumns(table);
    }

    private void updateTable(String table, List<ModelColumn> columns) throws SQLException {
        List alterSqls = columns.stream().map(this::getColumnDefinition).map(definition -> "ALTER TABLE " + table + " ADD COLUMN " + definition + "; ").collect(Collectors.toList());
        for (String alterSql : alterSqls) {
            this.executeSQL(new SQLBuilder(alterSql));
        }
    }

    private void createTable(String table, List<ModelColumn> columns, boolean isAdditionalTable) throws SQLException {
        ArrayList<Object> columnDefinitions = new ArrayList<Object>();
        columnDefinitions.add("id VARCHAR(512)" + (!isAdditionalTable ? " PRIMARY KEY" : ""));
        if (!isAdditionalTable) {
            columnDefinitions.add("table_name VARCHAR(512)");
        }
        columns.stream().map(this::getColumnDefinition).collect(Collectors.toCollection(() -> columnDefinitions));
        SQLBuilder sql = new SQLBuilder("CREATE TABLE IF NOT EXISTS " + table).append(columnDefinitions.stream().collect(Collectors.joining(", ", " (", ");")));
        this.executeSQL(sql);
    }

    private static class InstallInfoJDBC
    extends ModelInstaller.InstallInfo {
        private String tableName;
        private boolean tableExist;
        private boolean allColumnsExist;

        protected InstallInfoJDBC(Model model) {
            super(model);
        }

        public String buildInstallInfoMsg() {
            return "InstallInfoJDBC{modelName=" + this.getModelName() + ", modelType=" + this.getModelType() + ", timeSeries=" + this.isTimeSeries() + ", superDataset=" + this.isSuperDataset() + ", tableName=" + this.tableName + ", allResourcesExist=" + this.isAllExist() + " [tableExist=" + this.tableExist + ", allColumnsExist=" + this.allColumnsExist + "]}";
        }

        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public boolean isTableExist() {
            return this.tableExist;
        }

        @Generated
        public boolean isAllColumnsExist() {
            return this.allColumnsExist;
        }

        @Generated
        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Generated
        public void setTableExist(boolean tableExist) {
            this.tableExist = tableExist;
        }

        @Generated
        public void setAllColumnsExist(boolean allColumnsExist) {
            this.allColumnsExist = allColumnsExist;
        }
    }
}

