/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.RecordCondition;
import org.apache.skywalking.oap.server.core.query.type.Record;
import org.apache.skywalking.oap.server.core.storage.query.IRecordsQueryDAO;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.util.ByteUtil;

public class BanyanDBRecordsQueryDAO
extends AbstractBanyanDBDAO
implements IRecordsQueryDAO {
    public BanyanDBRecordsQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<Record> readRecords(final RecordCondition condition, final String valueColumnName, Duration duration) throws IOException {
        String modelName = condition.getName();
        TimestampRange timestampRange = new TimestampRange(duration.getStartTimestamp(), duration.getEndTimestamp());
        ImmutableSet tags = ImmutableSet.of((Object)"entity_id", (Object)"statement", (Object)"trace_id", (Object)valueColumnName);
        StreamQueryResponse resp = this.queryDebuggable(modelName, (Set<String>)tags, timestampRange, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                query.and(this.eq("entity_id", condition.getParentEntity().buildId()));
                if (condition.getOrder() == Order.DES) {
                    query.setOrderBy(new AbstractQuery.OrderBy(valueColumnName, AbstractQuery.Sort.DESC));
                } else {
                    query.setOrderBy(new AbstractQuery.OrderBy(valueColumnName, AbstractQuery.Sort.ASC));
                }
                query.setLimit(condition.getTopN());
            }
        });
        if (resp.size() == 0) {
            return Collections.emptyList();
        }
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findRecordMetadata(modelName);
        if (schema == null) {
            throw new IOException("schema is not registered");
        }
        MetadataRegistry.ColumnSpec spec = schema.getSpec(valueColumnName);
        if (spec == null) {
            throw new IOException("field spec is not registered");
        }
        ArrayList<Record> results = new ArrayList<Record>(condition.getTopN());
        for (RowEntity e : resp.getElements()) {
            Record record = new Record();
            String refId = (String)e.getTagValue("trace_id");
            record.setName((String)e.getTagValue("statement"));
            record.setRefId(StringUtil.isEmpty((String)refId) ? "" : refId);
            record.setId(record.getRefId());
            record.setValue(this.extractFieldValueAsString(spec, valueColumnName, e));
            results.add(record);
        }
        return results;
    }

    private String extractFieldValueAsString(MetadataRegistry.ColumnSpec spec, String fieldName, RowEntity e) throws IOException {
        if (Double.TYPE.equals(spec.getColumnClass())) {
            return String.valueOf(ByteUtil.bytes2Double((byte[])e.getTagValue(fieldName)).longValue());
        }
        if (String.class.equals(spec.getColumnClass())) {
            return (String)e.getTagValue(fieldName);
        }
        return String.valueOf(((Number)e.getTagValue(fieldName)).longValue());
    }
}

