/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.codec;

public class Base64 {
    private static final int BITS_PER_ENCODED_BYTE = 6;
    private static final int BYTES_PER_UNENCODED_BLOCK = 3;
    private static final int BYTES_PER_ENCODED_BLOCK = 4;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final int MASK_6BITS = 63;
    private final byte[] encodeTable;
    private final byte[] decodeTable = DECODE_TABLE;
    private final byte[] lineSeparator;
    private final int decodeSize;
    private final int encodeSize;
    private int bitWorkArea;
    private static final int MIME_CHUNK_SIZE = 76;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MASK_8BITS = 255;
    private static final byte PAD_DEFAULT = 61;
    private static final byte PAD = 61;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    private final int lineLength;
    private final int chunkSeparatorLength;
    private byte[] buffer;
    private int pos;
    private int readPos;
    private boolean eof;
    private int currentLinePos;
    private int modulus;

    public Base64() {
        this(0, CHUNK_SEPARATOR, false);
    }

    private Base64(int lineLength, byte[] lineSeparator, boolean urlSafe) {
        this.chunkSeparatorLength = lineSeparator.length;
        this.unencodedBlockSize = 3;
        this.encodedBlockSize = 4;
        int n = this.lineLength = lineLength > 0 && this.chunkSeparatorLength > 0 ? lineLength / this.encodedBlockSize * this.encodedBlockSize : 0;
        if (lineLength > 0) {
            this.encodeSize = 4 + lineSeparator.length;
            this.lineSeparator = new byte[lineSeparator.length];
            System.arraycopy(lineSeparator, 0, this.lineSeparator, 0, lineSeparator.length);
        } else {
            this.encodeSize = 4;
            this.lineSeparator = null;
        }
        this.decodeSize = this.encodeSize - 1;
        this.encodeTable = urlSafe ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
    }

    private byte[] encode(byte[] pArray) {
        this.reset();
        this.encode(pArray, 0, pArray.length);
        this.encode(pArray, 0, -1);
        byte[] buf = new byte[this.pos - this.readPos];
        this.readResults(buf, 0, buf.length);
        return buf;
    }

    void encode(byte[] in, int inPos, int inAvail) {
        if (this.eof) {
            return;
        }
        if (inAvail < 0) {
            this.eof = true;
            if (0 == this.modulus && this.lineLength == 0) {
                return;
            }
            this.ensureBufferSize(this.encodeSize);
            int savedPos = this.pos;
            switch (this.modulus) {
                case 1: {
                    this.buffer[this.pos++] = this.encodeTable[this.bitWorkArea >> 2 & 0x3F];
                    this.buffer[this.pos++] = this.encodeTable[this.bitWorkArea << 4 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    break;
                }
                case 2: {
                    this.buffer[this.pos++] = this.encodeTable[this.bitWorkArea >> 10 & 0x3F];
                    this.buffer[this.pos++] = this.encodeTable[this.bitWorkArea >> 4 & 0x3F];
                    this.buffer[this.pos++] = this.encodeTable[this.bitWorkArea << 2 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    this.buffer[this.pos++] = 61;
                    break;
                }
            }
            this.currentLinePos += this.pos - savedPos;
            if (this.lineLength > 0 && this.currentLinePos > 0) {
                System.arraycopy(this.lineSeparator, 0, this.buffer, this.pos, this.lineSeparator.length);
                this.pos += this.lineSeparator.length;
            }
        } else {
            for (int i = 0; i < inAvail; ++i) {
                this.ensureBufferSize(this.encodeSize);
                this.modulus = (this.modulus + 1) % 3;
                int b = in[inPos++];
                if (b < 0) {
                    b += 256;
                }
                this.bitWorkArea = (this.bitWorkArea << 8) + b;
                if (0 != this.modulus) continue;
                this.buffer[this.pos++] = this.encodeTable[this.bitWorkArea >> 18 & 0x3F];
                this.buffer[this.pos++] = this.encodeTable[this.bitWorkArea >> 12 & 0x3F];
                this.buffer[this.pos++] = this.encodeTable[this.bitWorkArea >> 6 & 0x3F];
                this.buffer[this.pos++] = this.encodeTable[this.bitWorkArea & 0x3F];
                this.currentLinePos += 4;
                if (this.lineLength <= 0 || this.lineLength > this.currentLinePos) continue;
                System.arraycopy(this.lineSeparator, 0, this.buffer, this.pos, this.lineSeparator.length);
                this.pos += this.lineSeparator.length;
                this.currentLinePos = 0;
            }
        }
    }

    private byte[] decode(byte[] pArray) {
        this.reset();
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        this.decode(pArray, 0, pArray.length);
        this.decode(pArray, 0, -1);
        byte[] result = new byte[this.pos];
        this.readResults(result, 0, result.length);
        return result;
    }

    void decode(byte[] in, int inPos, int inAvail) {
        if (this.eof) {
            return;
        }
        if (inAvail < 0) {
            this.eof = true;
        }
        for (int i = 0; i < inAvail; ++i) {
            byte result;
            this.ensureBufferSize(this.decodeSize);
            byte b = in[inPos++];
            if (b == 61) {
                this.eof = true;
                break;
            }
            if (b < 0 || b >= DECODE_TABLE.length || (result = DECODE_TABLE[b]) < 0) continue;
            this.modulus = (this.modulus + 1) % 4;
            this.bitWorkArea = (this.bitWorkArea << 6) + result;
            if (this.modulus != 0) continue;
            this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 16 & 0xFF);
            this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 8 & 0xFF);
            this.buffer[this.pos++] = (byte)(this.bitWorkArea & 0xFF);
        }
        if (this.eof && this.modulus != 0) {
            this.ensureBufferSize(this.decodeSize);
            switch (this.modulus) {
                case 2: {
                    this.bitWorkArea >>= 4;
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea & 0xFF);
                    break;
                }
                case 3: {
                    this.bitWorkArea >>= 2;
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea >> 8 & 0xFF);
                    this.buffer[this.pos++] = (byte)(this.bitWorkArea & 0xFF);
                    break;
                }
            }
        }
    }

    public static byte[] encodeBase64(byte[] binaryData) {
        return Base64.encodeBase64(binaryData, false, false, Integer.MAX_VALUE);
    }

    public static byte[] encodeBase64(byte[] binaryData, boolean isChunked, boolean urlSafe, int maxResultSize) {
        if (binaryData == null || binaryData.length == 0) {
            return binaryData;
        }
        Base64 b64 = isChunked ? new Base64(76, CHUNK_SEPARATOR, urlSafe) : new Base64(0, CHUNK_SEPARATOR, urlSafe);
        long len = b64.getEncodedLength(binaryData);
        if (len > (long)maxResultSize) {
            throw new IllegalArgumentException("Input array too big, the output array would be bigger (" + len + ") than the specified maximum size of " + maxResultSize);
        }
        return b64.encode(binaryData);
    }

    public static byte[] decodeBase64(byte[] base64Data) {
        return new Base64().decode(base64Data);
    }

    private void ensureBufferSize(int size) {
        if (this.buffer == null || this.buffer.length < this.pos + size) {
            if (this.buffer == null) {
                this.buffer = new byte[8192];
                this.pos = 0;
                this.readPos = 0;
            } else {
                byte[] b = new byte[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, b, 0, this.buffer.length);
                this.buffer = b;
            }
        }
    }

    private int readResults(byte[] b, int bPos, int bAvail) {
        if (this.buffer != null) {
            int len = Math.min(this.pos - this.readPos, bAvail);
            System.arraycopy(this.buffer, this.readPos, b, bPos, len);
            this.readPos += len;
            if (this.readPos >= this.pos) {
                this.buffer = null;
            }
            return len;
        }
        return this.eof ? -1 : 0;
    }

    private void reset() {
        this.buffer = null;
        this.pos = 0;
        this.readPos = 0;
        this.currentLinePos = 0;
        this.modulus = 0;
        this.eof = false;
    }

    private long getEncodedLength(byte[] pArray) {
        long len = (long)((pArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            len += (len + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return len;
    }
}

