/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.fetcher.cilium;

import io.cilium.api.flow.Endpoint;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.yaml.snakeyaml.Yaml;

public class ExcludeRules {
    private final Set<String> namespaces;
    private final List<Labels> labels;

    public static ExcludeRules loadRules(String path) throws IOException {
        try (FileReader r = new FileReader(ResourceUtils.getPath((String)path).toFile());){
            RuleYaml yaml = (RuleYaml)new Yaml().loadAs((Reader)r, RuleYaml.class);
            ExcludeRules excludeRules = new ExcludeRules(yaml);
            return excludeRules;
        }
    }

    public boolean shouldExclude(Endpoint endpoint) {
        if (this.namespaces.contains(endpoint.getNamespace())) {
            return true;
        }
        if (endpoint.getLabelsCount() == 0) {
            return false;
        }
        return this.labels.stream().anyMatch(label -> label.isMatch(endpoint));
    }

    private ExcludeRules(RuleYaml yaml) {
        this.namespaces = Set.copyOf(yaml.getNamespaces());
        this.labels = yaml.getLabels().stream().map(Labels::new).collect(Collectors.toList());
    }

    public static class RuleYaml {
        private List<String> namespaces;
        private List<Map<String, String>> labels;

        @Generated
        public RuleYaml() {
        }

        @Generated
        public List<String> getNamespaces() {
            return this.namespaces;
        }

        @Generated
        public List<Map<String, String>> getLabels() {
            return this.labels;
        }

        @Generated
        public void setNamespaces(List<String> namespaces) {
            this.namespaces = namespaces;
        }

        @Generated
        public void setLabels(List<Map<String, String>> labels) {
            this.labels = labels;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RuleYaml)) {
                return false;
            }
            RuleYaml other = (RuleYaml)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$namespaces = this.getNamespaces();
            List<String> other$namespaces = other.getNamespaces();
            if (this$namespaces == null ? other$namespaces != null : !((Object)this$namespaces).equals(other$namespaces)) {
                return false;
            }
            List<Map<String, String>> this$labels = this.getLabels();
            List<Map<String, String>> other$labels = other.getLabels();
            return !(this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RuleYaml;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $namespaces = this.getNamespaces();
            result = result * 59 + ($namespaces == null ? 43 : ((Object)$namespaces).hashCode());
            List<Map<String, String>> $labels = this.getLabels();
            result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExcludeRules.RuleYaml(namespaces=" + this.getNamespaces() + ", labels=" + this.getLabels() + ")";
        }
    }

    private static class Labels {
        private Map<String, String> labelMap;

        public Labels(Map<String, String> labelMap) {
            this.labelMap = labelMap;
        }

        public boolean isMatch(Endpoint endpoint) {
            int matchCount = 0;
            for (Map.Entry<String, String> entry : this.labelMap.entrySet()) {
                for (String endpointLabel : endpoint.getLabelsList()) {
                    if (endpointLabel.indexOf(entry.getKey()) != 0) continue;
                    if (!StringUtils.substring((String)endpointLabel, (int)(entry.getKey().length() + 1)).equals(entry.getValue())) {
                        return false;
                    }
                    if (++matchCount != this.labelMap.size()) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

