/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import lombok.Generated;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.StreamDefinition;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.meter.ScopeType;
import org.apache.skywalking.oap.server.core.analysis.meter.dynamic.MeterClassPackageHolder;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeterSystem
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MeterSystem.class);
    private static final String METER_CLASS_PACKAGE = "org.apache.skywalking.oap.server.core.analysis.meter.dynamic.";
    private ModuleManager manager;
    private ClassPool classPool;
    private Map<String, Class<? extends AcceptableValue>> functionRegister = new HashMap<String, Class<? extends AcceptableValue>>();
    private Map<String, MeterDefinition> meterPrototypes = new HashMap<String, MeterDefinition>();

    public MeterSystem(ModuleManager manager) {
        this.manager = manager;
        this.classPool = ClassPool.getDefault();
        ClassPath classpath = null;
        try {
            classpath = ClassPath.from((ClassLoader)MeterSystem.class.getClassLoader());
        }
        catch (IOException e) {
            throw new UnexpectedException("Load class path failure.");
        }
        ImmutableSet classes = classpath.getTopLevelClassesRecursive("org.apache.skywalking");
        for (ClassPath.ClassInfo classInfo : classes) {
            Class functionClass = classInfo.load();
            if (!functionClass.isAnnotationPresent(MeterFunction.class)) continue;
            MeterFunction metricsFunction = functionClass.getAnnotation(MeterFunction.class);
            if (!AcceptableValue.class.isAssignableFrom(functionClass)) {
                throw new IllegalArgumentException("Function " + functionClass.getCanonicalName() + " doesn't implement AcceptableValue.");
            }
            this.functionRegister.put(metricsFunction.functionName(), functionClass);
        }
    }

    public synchronized <T> void create(String metricsName, String functionName, ScopeType type) throws IllegalArgumentException {
        Class<? extends AcceptableValue> meterFunction = this.functionRegister.get(functionName);
        if (meterFunction == null) {
            throw new IllegalArgumentException("Function " + functionName + " can't be found.");
        }
        Type acceptance = null;
        for (Type genericInterface : meterFunction.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(genericInterface instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)genericInterface).getRawType().getTypeName().equals(AcceptableValue.class.getName())) continue;
            Type[] arguments = parameterizedType.getActualTypeArguments();
            acceptance = arguments[0];
            break;
        }
        try {
            this.create(metricsName, functionName, type, Class.forName(((Type)Objects.requireNonNull(acceptance)).getTypeName()));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized <T> void create(String metricsName, String functionName, ScopeType type, Class<T> dataType) throws IllegalArgumentException {
        CtClass parentClass;
        Class<? extends AcceptableValue> meterFunction = this.functionRegister.get(functionName);
        if (meterFunction == null) {
            throw new IllegalArgumentException("Function " + functionName + " can't be found.");
        }
        boolean foundDataType = false;
        String acceptance = null;
        for (Type genericInterface : meterFunction.getGenericInterfaces()) {
            if (!(genericInterface instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
            if (parameterizedType.getRawType().getTypeName().equals(AcceptableValue.class.getName())) {
                Type[] arguments = parameterizedType.getActualTypeArguments();
                if (arguments[0].equals(dataType)) {
                    foundDataType = true;
                } else {
                    acceptance = arguments[0].getTypeName();
                }
            }
            if (foundDataType) break;
        }
        if (!foundDataType) {
            throw new IllegalArgumentException("Function " + functionName + " requires <" + acceptance + "> in AcceptableValue but using " + dataType.getName() + " in the creation");
        }
        try {
            parentClass = this.classPool.get(meterFunction.getCanonicalName());
            if (!Metrics.class.isAssignableFrom(meterFunction)) {
                throw new IllegalArgumentException("Function " + functionName + " doesn't inherit from Metrics.");
            }
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Function " + functionName + " can't be found by javaassist.");
        }
        String className = MeterSystem.formatName(metricsName);
        try {
            CtClass existingMetric = this.classPool.get(METER_CLASS_PACKAGE + className);
            if (existingMetric.getSuperclass() != parentClass || type != this.meterPrototypes.get(metricsName).getScopeType()) {
                throw new IllegalArgumentException(metricsName + " has been defined, but calculate function or/are scope type is/are different.");
            }
            log.info("Metric {} is already defined, so skip the metric creation.", (Object)metricsName);
            return;
        }
        catch (NotFoundException existingMetric) {
            CtClass metricsClass = this.classPool.makeClass(METER_CLASS_PACKAGE + className, parentClass);
            try {
                CtConstructor defaultConstructor = CtNewConstructor.make((String)("public " + className + "() {}"), (CtClass)metricsClass);
                metricsClass.addConstructor(defaultConstructor);
            }
            catch (CannotCompileException e) {
                log.error("Can't add empty constructor in " + className + ".", (Throwable)e);
                throw new UnexpectedException(e.getMessage(), (Exception)((Object)e));
            }
            try {
                metricsClass.addMethod(CtNewMethod.make((String)("public org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue createNew() {    org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue meterVar = new org.apache.skywalking.oap.server.core.analysis.meter.dynamic." + className + "();    ((org.apache.skywalking.oap.server.core.analysis.meter.Meter)meterVar).initMeta(\"" + metricsName + "\", " + type.getScopeId() + ");    return meterVar; }"), (CtClass)metricsClass));
            }
            catch (CannotCompileException e) {
                log.error("Can't generate createNew method for " + className + ".", (Throwable)e);
                throw new UnexpectedException(e.getMessage(), (Exception)((Object)e));
            }
            try {
                Class targetClass = SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8) ? metricsClass.toClass(MeterSystem.class.getClassLoader(), null) : metricsClass.toClass(MeterClassPackageHolder.class);
                AcceptableValue prototype = (AcceptableValue)targetClass.newInstance();
                this.meterPrototypes.put(metricsName, new MeterDefinition(type, prototype, dataType));
                log.debug("Generate metrics class, " + metricsClass.getName());
                MetricsStreamProcessor.getInstance().create((ModuleDefineHolder)this.manager, new StreamDefinition(metricsName, type.getScopeId(), prototype.builder(), MetricsStreamProcessor.class), (Class<? extends Metrics>)targetClass);
            }
            catch (IllegalAccessException | InstantiationException | CannotCompileException | StorageException e) {
                log.error("Can't compile/load/init " + className + ".", e);
                throw new UnexpectedException(e.getMessage(), (Exception)e);
            }
            return;
        }
    }

    public <T> AcceptableValue<T> buildMetrics(String metricsName, Class<T> dataType) {
        MeterDefinition meterDefinition = this.meterPrototypes.get(metricsName);
        if (meterDefinition == null) {
            throw new IllegalArgumentException("Uncreated metrics " + metricsName);
        }
        if (!meterDefinition.getDataType().equals(dataType)) {
            throw new IllegalArgumentException("Unmatched metrics data type, request for " + dataType.getName() + ", but defined as " + meterDefinition.getDataType());
        }
        return meterDefinition.getMeterPrototype().createNew();
    }

    public void doStreamingCalculation(AcceptableValue acceptableValue) {
        long timeBucket = acceptableValue.getTimeBucket();
        if (timeBucket == 0L) {
            acceptableValue.setTimeBucket(TimeBucket.getMinuteTimeBucket(System.currentTimeMillis()));
        }
        MetricsStreamProcessor.getInstance().in((Metrics)((Object)acceptableValue));
    }

    private static String formatName(String metricsName) {
        return metricsName.toLowerCase();
    }

    private static class MeterDefinition {
        private final ScopeType scopeType;
        private final AcceptableValue meterPrototype;
        private final Class<?> dataType;

        @Generated
        public MeterDefinition(ScopeType scopeType, AcceptableValue meterPrototype, Class<?> dataType) {
            this.scopeType = scopeType;
            this.meterPrototype = meterPrototype;
            this.dataType = dataType;
        }

        @Generated
        public ScopeType getScopeType() {
            return this.scopeType;
        }

        @Generated
        public AcceptableValue getMeterPrototype() {
            return this.meterPrototype;
        }

        @Generated
        public Class<?> getDataType() {
            return this.dataType;
        }
    }
}

