/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.ebpf.analyze;

import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFOffCPUProfiling;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFOnCPUProfiling;
import org.apache.skywalking.apm.network.ebpf.profiling.v3.EBPFProfilingStackMetadata;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingDataRecord;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingStackType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzeAggregateType;

public class EBPFProfilingStack {
    private long uploadTime;
    private long dumpCount;
    private List<Symbol> symbols;

    public static EBPFProfilingStack deserialize(EBPFProfilingDataRecord record, EBPFProfilingAnalyzeAggregateType aggregateType) throws Exception {
        EBPFProfilingStack stack = new EBPFProfilingStack();
        EBPFProfilingStack.analyzeSymbolAndDimension(record, aggregateType, stack);
        stack.setUploadTime(record.getUploadTime());
        return stack;
    }

    private static void analyzeSymbolAndDimension(EBPFProfilingDataRecord record, EBPFProfilingAnalyzeAggregateType aggregateType, EBPFProfilingStack toStack) throws Exception {
        EBPFProfilingTargetType targetType = EBPFProfilingTargetType.valueOf(record.getTargetType());
        switch (targetType) {
            case ON_CPU: {
                EBPFOnCPUProfiling onCPUProfiling = EBPFOnCPUProfiling.parseFrom((byte[])record.getDataBinary());
                toStack.setDumpCount(onCPUProfiling.getDumpCount());
                toStack.setSymbols(EBPFProfilingStack.parseSymbols(onCPUProfiling.getStacksList()));
                break;
            }
            case OFF_CPU: {
                EBPFOffCPUProfiling offCPUProfiling = EBPFOffCPUProfiling.parseFrom((byte[])record.getDataBinary());
                toStack.setSymbols(EBPFProfilingStack.parseSymbols(offCPUProfiling.getStacksList()));
                if (aggregateType == EBPFProfilingAnalyzeAggregateType.DURATION) {
                    toStack.setDumpCount(offCPUProfiling.getDuration());
                    break;
                }
                toStack.setDumpCount(offCPUProfiling.getSwitchCount());
                break;
            }
            default: {
                throw new Exception("unknown target type: " + targetType);
            }
        }
    }

    private static List<Symbol> parseSymbols(List<EBPFProfilingStackMetadata> metadataList) {
        LinkedList<Symbol> symbols = new LinkedList<Symbol>();
        for (EBPFProfilingStackMetadata stack : metadataList) {
            stack.getStackSymbolsList().forEach(s -> symbols.addFirst(new Symbol((String)s, EBPFProfilingStackType.valueOf(stack.getStackType()))));
        }
        return symbols;
    }

    @Generated
    public EBPFProfilingStack() {
    }

    @Generated
    public long getUploadTime() {
        return this.uploadTime;
    }

    @Generated
    public long getDumpCount() {
        return this.dumpCount;
    }

    @Generated
    public List<Symbol> getSymbols() {
        return this.symbols;
    }

    @Generated
    public void setUploadTime(long uploadTime) {
        this.uploadTime = uploadTime;
    }

    @Generated
    public void setDumpCount(long dumpCount) {
        this.dumpCount = dumpCount;
    }

    @Generated
    public void setSymbols(List<Symbol> symbols) {
        this.symbols = symbols;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EBPFProfilingStack)) {
            return false;
        }
        EBPFProfilingStack other = (EBPFProfilingStack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUploadTime() != other.getUploadTime()) {
            return false;
        }
        if (this.getDumpCount() != other.getDumpCount()) {
            return false;
        }
        List<Symbol> this$symbols = this.getSymbols();
        List<Symbol> other$symbols = other.getSymbols();
        return !(this$symbols == null ? other$symbols != null : !((Object)this$symbols).equals(other$symbols));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EBPFProfilingStack;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $uploadTime = this.getUploadTime();
        result = result * 59 + (int)($uploadTime >>> 32 ^ $uploadTime);
        long $dumpCount = this.getDumpCount();
        result = result * 59 + (int)($dumpCount >>> 32 ^ $dumpCount);
        List<Symbol> $symbols = this.getSymbols();
        result = result * 59 + ($symbols == null ? 43 : ((Object)$symbols).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EBPFProfilingStack(uploadTime=" + this.getUploadTime() + ", dumpCount=" + this.getDumpCount() + ", symbols=" + this.getSymbols() + ")";
    }

    public static final class Symbol {
        private String name;
        private EBPFProfilingStackType stackType;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public EBPFProfilingStackType getStackType() {
            return this.stackType;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setStackType(EBPFProfilingStackType stackType) {
            this.stackType = stackType;
        }

        @Generated
        public String toString() {
            return "EBPFProfilingStack.Symbol(name=" + this.getName() + ", stackType=" + this.getStackType() + ")";
        }

        @Generated
        public Symbol(String name, EBPFProfilingStackType stackType) {
            this.name = name;
            this.stackType = stackType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Symbol)) {
                return false;
            }
            Symbol other = (Symbol)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            EBPFProfilingStackType this$stackType = this.getStackType();
            EBPFProfilingStackType other$stackType = other.getStackType();
            return !(this$stackType == null ? other$stackType != null : !((Object)((Object)this$stackType)).equals((Object)other$stackType));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            EBPFProfilingStackType $stackType = this.getStackType();
            result = result * 59 + ($stackType == null ? 43 : ((Object)((Object)$stackType)).hashCode());
            return result;
        }
    }
}

