/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Assert;
import graphql.Internal;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Internal
public class Vertex {
    private String type;
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private String debugName;
    private boolean isolated;
    private boolean builtInType;

    public static Vertex newIsolatedNode(String debugName) {
        Vertex vertex = new Vertex("__ISOLATED", debugName);
        vertex.isolated = true;
        return vertex;
    }

    public static Set<Vertex> newIsolatedNodes(int count, String debugName) {
        LinkedHashSet<Vertex> result = new LinkedHashSet<Vertex>();
        for (int i = 1; i <= count; ++i) {
            Vertex vertex = new Vertex("__ISOLATED", debugName + i);
            vertex.isolated = true;
            result.add(vertex);
        }
        return result;
    }

    public Vertex(String type, String debugName) {
        this.type = type;
        this.debugName = debugName;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public void add(String propName, Object propValue) {
        this.properties.put(propName, propValue);
    }

    public String getType() {
        return this.type;
    }

    public <T> T get(String propName) {
        return (T)this.properties.get(propName);
    }

    public <T> T getProperty(String name) {
        return (T)this.properties.get(name);
    }

    public String getName() {
        return (String)Assert.assertNotNull(this.properties.get("name"), () -> String.format("should not call getName on %s", this));
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getDebugName() {
        return this.debugName;
    }

    public boolean isOfType(String type) {
        return this.type.equals(type);
    }

    public boolean isEqualTo(Vertex other) {
        return other != null && Objects.equals(this.type, other.type) && Objects.equals(this.properties, other.properties);
    }

    public boolean isBuiltInType() {
        return this.builtInType;
    }

    public void setBuiltInType(boolean builtInType) {
        this.builtInType = builtInType;
    }

    public String toString() {
        return "Vertex{type='" + this.type + "', properties=" + this.properties.toString().replace("\n", "<NL>") + ", debugName='" + this.debugName + "', builtInType='" + this.builtInType + "'}";
    }

    public VertexData toData() {
        return new VertexData(this.type, this.properties);
    }

    public static class VertexData {
        private final String type;
        private final Map<String, Object> properties;

        public VertexData(String type, Map<String, Object> properties) {
            this.type = type;
            this.properties = properties;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VertexData that = (VertexData)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.properties, that.properties);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.properties);
        }
    }
}

