/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskLog;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskLogOperationType;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class ProfileTaskLogEsDAO
extends EsDAO
implements IProfileTaskLogQueryDAO {
    private final int queryMaxSize;

    public ProfileTaskLogEsDAO(ElasticSearchClient client, int profileTaskQueryMaxSize) {
        super(client);
        this.queryMaxSize = profileTaskQueryMaxSize * 50;
    }

    public List<ProfileTaskLog> getTaskLogList() throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("profile_task_log");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("profile_task_log")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"profile_task_log"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).sort("operation_time", Sort.Order.DESC).size(Integer.valueOf(this.queryMaxSize));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        LinkedList<ProfileTaskLog> tasks = new LinkedList<ProfileTaskLog>();
        for (SearchHit searchHit : response.getHits().getHits()) {
            tasks.add(this.parseTaskLog(searchHit));
        }
        return tasks;
    }

    private ProfileTaskLog parseTaskLog(SearchHit data) {
        return ProfileTaskLog.builder().id(data.getId()).taskId((String)data.getSource().get("task_id")).instanceId((String)data.getSource().get("instance_id")).operationType(ProfileTaskLogOperationType.parse((int)((Number)data.getSource().get("operation_type")).intValue())).operationTime(((Number)data.getSource().get("operation_time")).longValue()).build();
    }
}

