/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractEventLoopEntry;
import com.linecorp.armeria.client.AbstractEventLoopState;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.EventLoopScheduler;
import com.linecorp.armeria.client.SessionProtocolNegotiationCache;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.ReleasableHolder;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.ToIntFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultEventLoopScheduler
implements EventLoopScheduler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEventLoopScheduler.class);
    private static final AtomicLongFieldUpdater<DefaultEventLoopScheduler> lastCleanupTimeNanosUpdater = AtomicLongFieldUpdater.newUpdater(DefaultEventLoopScheduler.class, "lastCleanupTimeNanos");
    private static final AtomicIntegerFieldUpdater<DefaultEventLoopScheduler> acquisitionStartIndexUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultEventLoopScheduler.class, "acquisitionStartIndex");
    private static final long CLEANUP_INTERVAL_NANOS = Duration.ofMinutes(1L).toNanos();
    static final int DEFAULT_MAX_NUM_EVENT_LOOPS = 1;
    private final ReentrantLock lock = new ReentrantShortLock();
    private final List<EventLoop> eventLoops;
    private final int maxNumEventLoopsPerEndpoint;
    private final int maxNumEventLoopsPerHttp1Endpoint;
    private final Map<StateKey, AbstractEventLoopState> states = new ConcurrentHashMap<StateKey, AbstractEventLoopState>();
    private final List<ToIntFunction<Endpoint>> maxNumEventLoopsFunctions;
    private int cleanupCounter;
    private volatile int acquisitionStartIndex;
    private volatile long lastCleanupTimeNanos = System.nanoTime();

    DefaultEventLoopScheduler(EventLoopGroup eventLoopGroup, int maxNumEventLoopsPerEndpoint, int maxNumEventLoopsPerHttp1Endpoint, List<ToIntFunction<Endpoint>> maxNumEventLoopsFunctions) {
        this.eventLoops = Streams.stream(eventLoopGroup).map(EventLoop.class::cast).collect(ImmutableList.toImmutableList());
        int eventLoopSize = this.eventLoops.size();
        this.acquisitionStartIndex = ThreadLocalRandom.current().nextInt(eventLoopSize);
        this.maxNumEventLoopsPerEndpoint = maxNumEventLoopsPerEndpoint <= 0 ? 1 : Math.min(maxNumEventLoopsPerEndpoint, eventLoopSize);
        this.maxNumEventLoopsPerHttp1Endpoint = maxNumEventLoopsPerHttp1Endpoint <= 0 ? this.maxNumEventLoopsPerEndpoint : Math.min(maxNumEventLoopsPerHttp1Endpoint, eventLoopSize);
        this.maxNumEventLoopsFunctions = ImmutableList.copyOf(maxNumEventLoopsFunctions);
    }

    int acquisitionStartIndex(int need) {
        int next;
        int current;
        while (!acquisitionStartIndexUpdater.compareAndSet(this, current = this.acquisitionStartIndex, next = (current + need) % this.eventLoops.size())) {
        }
        return current;
    }

    @Override
    public ReleasableHolder<EventLoop> acquire(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, @Nullable Endpoint endpoint) {
        Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        AbstractEventLoopState state = this.state(sessionProtocol, endpointGroup, endpoint);
        AbstractEventLoopEntry acquired = state.acquire();
        this.cleanup();
        return acquired;
    }

    AbstractEventLoopEntry[] entries(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, @Nullable Endpoint endpoint) {
        return this.state(sessionProtocol, endpointGroup, endpoint).entries();
    }

    private AbstractEventLoopState state(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, @Nullable Endpoint endpoint) {
        StateKey secondKey;
        String secondTryHost;
        String firstTryHost;
        if (endpoint == null) {
            endpoint = Endpoint.unsafeCreate("armeria-group-" + Integer.toHexString(System.identityHashCode(endpointGroup)), 0);
        }
        if (endpoint.hasIpAddr()) {
            String ipAddr = endpoint.ipAddr();
            assert (ipAddr != null);
            firstTryHost = ipAddr;
            secondTryHost = endpoint.isIpAddrOnly() ? null : endpoint.host();
        } else {
            firstTryHost = endpoint.host();
            secondTryHost = null;
        }
        Endpoint endpointWithPort = endpoint.withDefaultPort(sessionProtocol);
        int port = endpointWithPort.port();
        boolean isHttp1 = DefaultEventLoopScheduler.isHttp1(sessionProtocol, endpointWithPort);
        StateKey firstKey = new StateKey(firstTryHost, port, isHttp1);
        AbstractEventLoopState state = this.states.get(firstKey);
        if (state != null) {
            return state;
        }
        if (secondTryHost != null && (state = this.states.get(secondKey = new StateKey(secondTryHost, port, isHttp1))) != null) {
            return state;
        }
        int maxNumEventLoopsCandidate = this.maxNumEventLoopsCandidate(endpointWithPort);
        if (maxNumEventLoopsCandidate <= 0 && !endpointWithPort.equals(endpoint)) {
            maxNumEventLoopsCandidate = this.maxNumEventLoopsCandidate(endpoint);
        }
        int maxNumEventLoops = maxNumEventLoopsCandidate > 0 ? Math.min(maxNumEventLoopsCandidate, this.eventLoops.size()) : this.maxNumEventLoops(sessionProtocol, endpointWithPort);
        return this.states.computeIfAbsent(firstKey, unused -> AbstractEventLoopState.of(this.eventLoops, maxNumEventLoops, this));
    }

    private int maxNumEventLoopsCandidate(Endpoint endpoint) {
        for (ToIntFunction<Endpoint> function : this.maxNumEventLoopsFunctions) {
            int maxNumEventLoopsCandidate = function.applyAsInt(endpoint);
            if (maxNumEventLoopsCandidate <= 0) continue;
            logger.debug("maxNumEventLoops: {}, for the endpoint: {}", (Object)maxNumEventLoopsCandidate, (Object)endpoint);
            return maxNumEventLoopsCandidate;
        }
        return 0;
    }

    private int maxNumEventLoops(SessionProtocol sessionProtocol, Endpoint endpointWithPort) {
        return DefaultEventLoopScheduler.isHttp1(sessionProtocol, endpointWithPort) ? this.maxNumEventLoopsPerHttp1Endpoint : this.maxNumEventLoopsPerEndpoint;
    }

    private static boolean isHttp1(SessionProtocol sessionProtocol, Endpoint endpointWithPort) {
        if (sessionProtocol == SessionProtocol.H1C || sessionProtocol == SessionProtocol.H1) {
            return true;
        }
        if (sessionProtocol == SessionProtocol.HTTP) {
            return SessionProtocolNegotiationCache.isUnsupported(endpointWithPort, SessionProtocol.H2C);
        }
        if (sessionProtocol == SessionProtocol.HTTPS) {
            return SessionProtocolNegotiationCache.isUnsupported(endpointWithPort, SessionProtocol.H2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        long lastCleanupTimeNanos;
        if ((++this.cleanupCounter & 0xFF) != 0) {
            return;
        }
        long currentTimeNanos = System.nanoTime();
        if (currentTimeNanos - (lastCleanupTimeNanos = this.lastCleanupTimeNanos) < CLEANUP_INTERVAL_NANOS || !lastCleanupTimeNanosUpdater.compareAndSet(this, lastCleanupTimeNanos, currentTimeNanos)) {
            return;
        }
        Iterator<AbstractEventLoopState> i = this.states.values().iterator();
        while (i.hasNext()) {
            boolean remove;
            AbstractEventLoopState state = i.next();
            this.lock.lock();
            try {
                remove = state.allActiveRequests() == 0 && currentTimeNanos - state.lastActivityTimeNanos() >= CLEANUP_INTERVAL_NANOS;
            }
            finally {
                this.lock.unlock();
            }
            if (!remove) continue;
            i.remove();
        }
    }

    private static final class StateKey {
        private final String ipOrHost;
        private final int port;
        private final boolean isHttp1;

        StateKey(String ipOrHost, int port, boolean isHttp1) {
            this.ipOrHost = ipOrHost;
            this.port = port;
            this.isHttp1 = isHttp1;
        }

        public int hashCode() {
            return (this.ipOrHost.hashCode() * 31 + this.port) * 31 + Boolean.hashCode(this.isHttp1);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StateKey)) {
                return false;
            }
            StateKey that = (StateKey)obj;
            return this.ipOrHost.equals(that.ipOrHost) && this.port == that.port && this.isHttp1 == that.isHttp1;
        }
    }
}

