/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.retry.AttemptLimitingBackoff;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.JitterAddingBackoff;
import com.linecorp.armeria.common.annotation.Nullable;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;

abstract class AbstractBackoffBuilder<SELF extends AbstractBackoffBuilder<SELF>> {
    @Nullable
    private Double minJitterRate;
    @Nullable
    private Double maxJitterRate;
    @Nullable
    private Integer maxAttempts;
    @Nullable
    private Supplier<Random> randomSupplier;

    AbstractBackoffBuilder() {
    }

    private SELF self() {
        return (SELF)this;
    }

    public final SELF jitter(double minJitterRate, double maxJitterRate) {
        this.minJitterRate = minJitterRate;
        this.maxJitterRate = maxJitterRate;
        return this.self();
    }

    public final SELF jitter(double minJitterRate, double maxJitterRate, Supplier<Random> randomSupplier) {
        Objects.requireNonNull(randomSupplier, "randomSupplier");
        this.minJitterRate = minJitterRate;
        this.maxJitterRate = maxJitterRate;
        this.randomSupplier = randomSupplier;
        return this.self();
    }

    public final SELF maxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this.self();
    }

    abstract Backoff doBuild();

    public final Backoff build() {
        Backoff backoff = this.doBuild();
        if (this.minJitterRate != null && this.maxJitterRate != null) {
            Supplier<Random> randomSupplier = this.randomSupplier;
            if (randomSupplier == null) {
                randomSupplier = ThreadLocalRandom::current;
            }
            backoff = new JitterAddingBackoff(backoff, this.minJitterRate, this.maxJitterRate, randomSupplier);
        }
        if (this.maxAttempts != null) {
            backoff = new AttemptLimitingBackoff(backoff, this.maxAttempts);
        }
        return backoff;
    }
}

