/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.ClientRequestContextCaptor;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public final class ClientThreadLocalState {
    private static final FastThreadLocal<ClientThreadLocalState> threadLocalState = new FastThreadLocal();
    @Nullable
    private ArrayList<Consumer<? super ClientRequestContext>> customizers;
    @Nullable
    private DefaultClientRequestContextCaptor pendingContextCaptor;

    @Nullable
    public static ClientThreadLocalState get() {
        return (ClientThreadLocalState)threadLocalState.get();
    }

    public static ClientThreadLocalState maybeCreate() {
        ClientThreadLocalState state = (ClientThreadLocalState)threadLocalState.get();
        if (state == null) {
            state = new ClientThreadLocalState();
            threadLocalState.set((Object)state);
        }
        return state;
    }

    private ClientThreadLocalState() {
    }

    public void add(Consumer<? super ClientRequestContext> customizer) {
        if (this.customizers == null) {
            this.customizers = new ArrayList();
        }
        this.customizers.add(customizer);
    }

    public void remove(Consumer<? super ClientRequestContext> customizer) {
        if (this.customizers != null) {
            for (int i = this.customizers.size() - 1; i >= 0; --i) {
                if (this.customizers.get(i) != customizer) continue;
                this.customizers.remove(i);
                this.maybeRemoveThreadLocal();
                return;
            }
        }
        ClientThreadLocalState.reportThreadSafetyViolation();
    }

    public ClientRequestContextCaptor newContextCaptor() {
        DefaultClientRequestContextCaptor oldPendingContextCaptor = this.pendingContextCaptor;
        this.pendingContextCaptor = new DefaultClientRequestContextCaptor(oldPendingContextCaptor);
        return this.pendingContextCaptor;
    }

    void addCapturedContext(ClientRequestContext ctx) {
        if (this.pendingContextCaptor != null) {
            this.pendingContextCaptor.add(ctx);
        }
    }

    void maybeRemoveThreadLocal() {
        if (this.pendingContextCaptor != null || this.customizers != null && !this.customizers.isEmpty()) {
            return;
        }
        ClientThreadLocalState actualState = (ClientThreadLocalState)threadLocalState.get();
        if (actualState != this) {
            ClientThreadLocalState.reportThreadSafetyViolation();
            return;
        }
        threadLocalState.remove();
    }

    private static void reportThreadSafetyViolation() {
        String safeCloseable = SafeCloseable.class.getSimpleName();
        throw new IllegalStateException("Failed to remove a context customizer. Did you call " + safeCloseable + ".close() manually on a different thread? Use try-resources or make sure " + safeCloseable + ".close() is called on the same thread as the one that created it.");
    }

    @Nullable
    List<Consumer<? super ClientRequestContext>> copyCustomizers() {
        if (this.customizers == null || this.customizers.isEmpty()) {
            return null;
        }
        return ImmutableList.copyOf(this.customizers);
    }

    private final class DefaultClientRequestContextCaptor
    implements ClientRequestContextCaptor {
        final List<ClientRequestContext> captured = new ArrayList<ClientRequestContext>();
        @Nullable
        private DefaultClientRequestContextCaptor oldCaptor;

        DefaultClientRequestContextCaptor(DefaultClientRequestContextCaptor oldCaptor) {
            this.oldCaptor = oldCaptor;
        }

        void add(ClientRequestContext ctx) {
            this.captured.add(ctx);
            if (this.oldCaptor != null) {
                this.oldCaptor.add(ctx);
            }
        }

        @Override
        public ClientRequestContext get() {
            if (this.captured.isEmpty()) {
                throw new NoSuchElementException("No context was captured; no request was made?");
            }
            return this.captured.get(0);
        }

        @Override
        @Nullable
        public ClientRequestContext getOrNull() {
            if (!this.captured.isEmpty()) {
                return this.captured.get(0);
            }
            return null;
        }

        @Override
        public List<ClientRequestContext> getAll() {
            return ImmutableList.copyOf(this.captured);
        }

        @Override
        public int size() {
            return this.captured.size();
        }

        @Override
        public void close() {
            ClientThreadLocalState.this.pendingContextCaptor = this.oldCaptor;
            this.oldCaptor = null;
            ClientThreadLocalState.this.maybeRemoveThreadLocal();
        }
    }
}

