/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.crypto.paddings;

import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.InvalidCipherTextException;
import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class PKCS7Padding
implements BlockCipherPadding {
    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
    }

    public int addPadding(byte[] byArray, int n) {
        byte by = (byte)(byArray.length - n);
        while (n < byArray.length) {
            byArray[n] = by;
            ++n;
        }
        return by;
    }

    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n = byArray[byArray.length - 1] & 0xFF;
        byte by = (byte)n;
        boolean bl = n > byArray.length | n == 0;
        for (int i = 0; i < byArray.length; ++i) {
            bl |= byArray.length - i <= n & byArray[i] != by;
        }
        if (bl) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n;
    }
}

