/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als;

import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.service.accesslog.v3.StreamAccessLogsMessage;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetrics;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.Role;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;

public interface AccessLogAnalyzer<E> {
    public String name();

    public void init(ModuleManager var1, EnvoyMetricReceiverConfig var2) throws ModuleStartException;

    public Result analysis(Result var1, StreamAccessLogsMessage.Identifier var2, E var3, Role var4);

    default public Role identify(StreamAccessLogsMessage.Identifier alsIdentifier, Role defaultRole) {
        if (alsIdentifier == null) {
            return defaultRole;
        }
        if (!alsIdentifier.hasNode()) {
            return defaultRole;
        }
        Node node = alsIdentifier.getNode();
        String id = node.getId();
        if (id.startsWith("router~")) {
            return Role.PROXY;
        }
        if (id.startsWith("sidecar~")) {
            return Role.SIDECAR;
        }
        return defaultRole;
    }

    public static class Result {
        private ServiceMetaInfo service;
        private ServiceMeshMetrics.Builder metrics;
        private boolean hasDownstreamMetrics;
        private boolean hasUpstreamMetrics;
        private final AtomicReference<Object> hasResult = new AtomicReference();

        @Generated
        private static ServiceMeshMetrics.Builder $default$metrics() {
            return ServiceMeshMetrics.newBuilder();
        }

        @Generated
        Result(ServiceMetaInfo service, ServiceMeshMetrics.Builder metrics, boolean hasDownstreamMetrics, boolean hasUpstreamMetrics) {
            this.service = service;
            this.metrics = metrics;
            this.hasDownstreamMetrics = hasDownstreamMetrics;
            this.hasUpstreamMetrics = hasUpstreamMetrics;
        }

        @Generated
        public static ResultBuilder builder() {
            return new ResultBuilder();
        }

        @Generated
        public ResultBuilder toBuilder() {
            return new ResultBuilder().service(this.service).metrics(this.metrics).hasDownstreamMetrics(this.hasDownstreamMetrics).hasUpstreamMetrics(this.hasUpstreamMetrics);
        }

        @Generated
        public ServiceMetaInfo getService() {
            return this.service;
        }

        @Generated
        public ServiceMeshMetrics.Builder getMetrics() {
            return this.metrics;
        }

        @Generated
        public boolean hasDownstreamMetrics() {
            return this.hasDownstreamMetrics;
        }

        @Generated
        public boolean hasUpstreamMetrics() {
            return this.hasUpstreamMetrics;
        }

        @Generated
        public void setService(ServiceMetaInfo service) {
            this.service = service;
        }

        @Generated
        public void setMetrics(ServiceMeshMetrics.Builder metrics) {
            this.metrics = metrics;
        }

        @Generated
        public Result hasDownstreamMetrics(boolean hasDownstreamMetrics) {
            this.hasDownstreamMetrics = hasDownstreamMetrics;
            return this;
        }

        @Generated
        public Result hasUpstreamMetrics(boolean hasUpstreamMetrics) {
            this.hasUpstreamMetrics = hasUpstreamMetrics;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.hasDownstreamMetrics() != other.hasDownstreamMetrics()) {
                return false;
            }
            if (this.hasUpstreamMetrics() != other.hasUpstreamMetrics()) {
                return false;
            }
            if (this.hasResult() != other.hasResult()) {
                return false;
            }
            ServiceMetaInfo this$service = this.getService();
            ServiceMetaInfo other$service = other.getService();
            if (this$service == null ? other$service != null : !((Object)this$service).equals(other$service)) {
                return false;
            }
            ServiceMeshMetrics.Builder this$metrics = this.getMetrics();
            ServiceMeshMetrics.Builder other$metrics = other.getMetrics();
            return !(this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.hasDownstreamMetrics() ? 79 : 97);
            result = result * 59 + (this.hasUpstreamMetrics() ? 79 : 97);
            result = result * 59 + (this.hasResult() ? 79 : 97);
            ServiceMetaInfo $service = this.getService();
            result = result * 59 + ($service == null ? 43 : ((Object)$service).hashCode());
            ServiceMeshMetrics.Builder $metrics = this.getMetrics();
            result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccessLogAnalyzer.Result(service=" + this.getService() + ", metrics=" + this.getMetrics() + ", hasDownstreamMetrics=" + this.hasDownstreamMetrics() + ", hasUpstreamMetrics=" + this.hasUpstreamMetrics() + ", hasResult=" + this.hasResult() + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public boolean hasResult() {
            Object value = this.hasResult.get();
            if (value == null) {
                AtomicReference<Object> atomicReference = this.hasResult;
                synchronized (atomicReference) {
                    value = this.hasResult.get();
                    if (value == null) {
                        boolean actualValue = this.hasDownstreamMetrics || this.hasUpstreamMetrics;
                        value = actualValue;
                        this.hasResult.set(value);
                    }
                }
            }
            return (Boolean)value;
        }

        @Generated
        public static class ResultBuilder {
            @Generated
            private ServiceMetaInfo service;
            @Generated
            private boolean metrics$set;
            @Generated
            private ServiceMeshMetrics.Builder metrics$value;
            @Generated
            private boolean hasDownstreamMetrics;
            @Generated
            private boolean hasUpstreamMetrics;

            @Generated
            ResultBuilder() {
            }

            @Generated
            public ResultBuilder service(ServiceMetaInfo service) {
                this.service = service;
                return this;
            }

            @Generated
            public ResultBuilder metrics(ServiceMeshMetrics.Builder metrics) {
                this.metrics$value = metrics;
                this.metrics$set = true;
                return this;
            }

            @Generated
            public ResultBuilder hasDownstreamMetrics(boolean hasDownstreamMetrics) {
                this.hasDownstreamMetrics = hasDownstreamMetrics;
                return this;
            }

            @Generated
            public ResultBuilder hasUpstreamMetrics(boolean hasUpstreamMetrics) {
                this.hasUpstreamMetrics = hasUpstreamMetrics;
                return this;
            }

            @Generated
            public Result build() {
                ServiceMeshMetrics.Builder metrics$value = this.metrics$value;
                if (!this.metrics$set) {
                    metrics$value = Result.$default$metrics();
                }
                return new Result(this.service, metrics$value, this.hasDownstreamMetrics, this.hasUpstreamMetrics);
            }

            @Generated
            public String toString() {
                return "AccessLogAnalyzer.Result.ResultBuilder(service=" + this.service + ", metrics$value=" + this.metrics$value + ", hasDownstreamMetrics=" + this.hasDownstreamMetrics + ", hasUpstreamMetrics=" + this.hasUpstreamMetrics + ")";
            }
        }
    }
}

