/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.metrics.adapters;

import io.prometheus.client.Metrics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Counter;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Gauge;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Histogram;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Metric;
import org.apache.skywalking.oap.server.receiver.envoy.metrics.adapters.ClusterManagerMetricsAdapter;

public class ProtoMetricFamily2MetricsAdapter {
    protected final Metrics.MetricFamily metricFamily;
    private final ClusterManagerMetricsAdapter clusterManagerMetricsAdapter;

    public Stream<Metric> adapt() {
        switch (this.metricFamily.getType()) {
            case COUNTER: {
                return this.metricFamily.getMetricList().stream().map(it -> Counter.builder().name(this.adaptMetricsName((Metrics.Metric)it)).value(it.getCounter().getValue()).timestamp(this.adaptTimestamp((Metrics.Metric)it)).labels(this.adaptLabels((Metrics.Metric)it)).build());
            }
            case GAUGE: {
                return this.metricFamily.getMetricList().stream().map(it -> Gauge.builder().name(this.adaptMetricsName((Metrics.Metric)it)).value(this.adaptValue((Metrics.Metric)it)).timestamp(this.adaptTimestamp((Metrics.Metric)it)).labels(this.adaptLabels((Metrics.Metric)it)).build());
            }
            case HISTOGRAM: {
                return this.metricFamily.getMetricList().stream().map(it -> Histogram.builder().name(this.adaptMetricsName((Metrics.Metric)it)).labels(this.adaptLabels((Metrics.Metric)it)).sampleCount(it.getHistogram().getSampleCount()).sampleSum(it.getHistogram().getSampleSum()).buckets(ProtoMetricFamily2MetricsAdapter.buildBuckets(it.getHistogram().getBucketList())).build());
            }
        }
        return Stream.of(new Metric[0]);
    }

    public String adaptMetricsName(Metrics.Metric metric) {
        if (this.metricFamily.getName().startsWith("cluster.")) {
            return this.clusterManagerMetricsAdapter.adaptMetricsName(this.metricFamily);
        }
        return this.metricFamily.getName();
    }

    public double adaptValue(Metrics.Metric it) {
        return it.getGauge().getValue();
    }

    public Map<String, String> adaptLabels(Metrics.Metric metric) {
        Map<String, String> labels = metric.getLabelList().stream().collect(Collectors.toMap(Metrics.LabelPair::getName, Metrics.LabelPair::getValue));
        if (this.metricFamily.getName().startsWith("cluster.")) {
            return this.clusterManagerMetricsAdapter.adaptLabels(this.metricFamily, labels);
        }
        return labels;
    }

    public long adaptTimestamp(Metrics.Metric metric) {
        long timestamp = metric.getTimestampMs();
        if (timestamp > 1000000000000000000L) {
            timestamp /= 1000000L;
        }
        return timestamp;
    }

    private static Map<Double, Long> buildBuckets(List<Metrics.Bucket> buckets) {
        HashMap<Double, Long> result = new HashMap<Double, Long>();
        for (Metrics.Bucket bucket : buckets) {
            result.put(bucket.getUpperBound(), bucket.getCumulativeCount());
        }
        return result;
    }

    @Generated
    public ProtoMetricFamily2MetricsAdapter(Metrics.MetricFamily metricFamily, ClusterManagerMetricsAdapter clusterManagerMetricsAdapter) {
        this.metricFamily = metricFamily;
        this.clusterManagerMetricsAdapter = clusterManagerMetricsAdapter;
    }
}

