/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.jspc;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.maven.jspc.classloader.DynamicClassLoaderManagerFactory;
import org.apache.sling.maven.jspc.classloader.DynamicClassLoaderManagerImpl;
import org.apache.sling.scripting.jsp.SlingTldLocationsCache;
import org.apache.sling.scripting.jsp.jasper.compiler.TldLocationsCache;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class FeatureSupport {
    private final Framework framework;
    private final ClassLoader loader;
    private final TldLocationsCache locationsCache;
    private final Feature feature;

    public FeatureSupport(Framework framework, ClassLoader loader, TldLocationsCache locationsCache, Feature feature) {
        this.framework = framework;
        this.loader = loader;
        this.locationsCache = locationsCache;
        this.feature = feature;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public TldLocationsCache getTldLocationsCache() {
        return this.locationsCache;
    }

    public Feature getFeature() {
        return this.feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FeatureSupport createFeatureSupport(Feature feature, ArtifactProvider provider, ClassLoader loader, boolean failOnUnresolvedBundles, Function<Map<String, String>, Map<String, String>> frameworkPropertiesHandler) throws BundleException {
        FrameworkFactory factory = ServiceLoader.load(FrameworkFactory.class, loader).iterator().next();
        Map<Object, Object> properties = new HashMap(feature.getFrameworkProperties());
        properties = frameworkPropertiesHandler.apply(properties);
        HashMap frameworkProperties = new HashMap();
        properties.forEach((key, value) -> frameworkProperties.put(key, value.replace("{dollar}", "$")));
        Framework framework = factory.newFramework(frameworkProperties);
        framework.init();
        try {
            List<Bundle> bundles = FeatureSupport.install(framework, feature, provider);
            framework.start();
            for (Bundle bundle : bundles) {
                boolean resolved;
                if (bundle.getState() == 4 || (resolved = ((FrameworkWiring)framework.adapt(FrameworkWiring.class)).resolveBundles(Arrays.asList(bundle))) || !failOnUnresolvedBundles) continue;
                throw new BundleException("Unable to resolve bundle: " + bundle.getLocation());
            }
            ServiceTracker tracker = new ServiceTracker(framework.getBundleContext(), PackageAdmin.class, null);
            tracker.open();
            PackageAdmin admin = (PackageAdmin)tracker.waitForService(1000L);
            DynamicClassLoaderManagerImpl manager = new DynamicClassLoaderManagerImpl(framework.getBundleContext(), admin, loader, new DynamicClassLoaderManagerFactory(framework.getBundleContext(), admin));
            SlingTldLocationsCache tldLocationsCache = new SlingTldLocationsCache(framework.getBundleContext());
            FeatureSupport featureSupport = new FeatureSupport(framework, manager.getDynamicClassLoader(), (TldLocationsCache)tldLocationsCache, feature);
            return featureSupport;
        }
        catch (Throwable t) {
            try {
                framework.stop();
                framework.waitForStop(10000L);
            }
            finally {
                throw new RuntimeException(t);
            }
        }
    }

    private static List<Bundle> install(Framework framework, Feature feature, ArtifactProvider provider) throws BundleException {
        BundleContext bc = framework.getBundleContext();
        int defaultStartLevel = FeatureSupport.getProperty(bc, "felix.startlevel.bundle", 1);
        Map bundlesByStartOrder = feature.getBundles().getBundlesByStartOrder();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Integer startLevel : FeatureSupport.sortStartLevels(bundlesByStartOrder.keySet(), defaultStartLevel)) {
            for (Artifact bundleArtifact : (List)bundlesByStartOrder.get(startLevel)) {
                Bundle bundle;
                URL url = provider.provide(bundleArtifact.getId());
                String location = "";
                if (url.getProtocol().equals("file")) {
                    location = "reference:";
                }
                if (FeatureSupport.isSystemBundleFragment(bundle = bc.installBundle(location = location + url.toString(), null)) || FeatureSupport.getFragmentHostHeader(bundle) != null) continue;
                bundles.add(bundle);
            }
        }
        return bundles;
    }

    private static int getProperty(BundleContext bc, String propName, int defaultValue) {
        String val = bc.getProperty(propName);
        if (val == null) {
            return defaultValue;
        }
        return Integer.parseInt(val);
    }

    private static Iterable<Integer> sortStartLevels(Collection<Integer> startLevels, int defaultStartLevel) {
        ArrayList<Integer> result = new ArrayList<Integer>(startLevels);
        Collections.sort(result, (o1, o2) -> {
            int i1 = o1 == 0 ? defaultStartLevel : o1;
            int i2 = o2 == 0 ? defaultStartLevel : o2;
            return Integer.compare(i1, i2);
        });
        return result;
    }

    private static boolean isSystemBundleFragment(Bundle installedBundle) {
        String fragmentHeader = FeatureSupport.getFragmentHostHeader(installedBundle);
        return fragmentHeader != null && fragmentHeader.indexOf("extension") > 0;
    }

    private static String getFragmentHostHeader(Bundle b) {
        return (String)b.getHeaders().get("Fragment-Host");
    }

    public void shutdown(long timeout) throws Exception {
        this.framework.stop();
        this.framework.waitForStop(timeout);
    }
}

