/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.capabilities.jcr;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.capabilities.CapabilitiesSource;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={CapabilitiesSource.class})
@Designate(ocd=Config.class)
public class SearchSource
implements CapabilitiesSource {
    public static final String NAMESPACE = "org.apache.sling.jcr.search";
    public static final String SSA_PROP_NAME = "similarity.search.active";
    public static final String SUBSERVICE_NAME = "search";
    public static final String DEFAULT_QUERY = "/jcr:root/oak:index//* [@useInSimilarity = true]";
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    private String similaritySearchActiveResult;
    private long similaritySearchCacheExpires;
    private int cacheLifetimeSeconds;
    private String similarityIndexQuery;
    @Reference
    private SlingRepository repository;
    @Reference(target="(subServiceName=search)")
    private ServiceUserMapped scriptServiceUserMapped;

    @Activate
    protected void activate(Config cfg, ComponentContext ctx) {
        this.similarityIndexQuery = cfg.similarityIndexQuery();
        this.cacheLifetimeSeconds = cfg.cacheLifetimeSeconds();
    }

    public Map<String, Object> getCapabilities(ResourceResolver rr) throws Exception {
        this.refreshCachedValues(rr);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(SSA_PROP_NAME, this.similaritySearchActiveResult);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCachedValues(ResourceResolver unused) {
        if (System.currentTimeMillis() < this.similaritySearchCacheExpires) {
            this.log.debug("Using cached similaritySearchActive value");
            return;
        }
        this.similaritySearchCacheExpires = System.currentTimeMillis() + (long)this.cacheLifetimeSeconds * 1000L;
        SearchSource searchSource = this;
        synchronized (searchSource) {
            Session session = null;
            try {
                session = this.repository.loginService(SUBSERVICE_NAME, null);
                QueryManager qm = session.getWorkspace().getQueryManager();
                QueryResult qr = qm.createQuery(this.similarityIndexQuery, "xpath").execute();
                this.similaritySearchActiveResult = String.valueOf(qr.getNodes().hasNext());
            }
            catch (RepositoryException rex) {
                this.similaritySearchActiveResult = rex.toString();
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
        this.log.debug("Recomputed {}={} using query {}", new Object[]{SSA_PROP_NAME, this.similaritySearchActiveResult, this.similarityIndexQuery});
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    @ObjectClassDefinition(name="Apache Sling JCR Capabilities - Search Source", description="Provides information JCR search features")
    public static @interface Config {
        @AttributeDefinition(name="Similarity Index Query", description="A JCR XPAth query that returns at least 1 Node if similarity search is available. The service user that this component uses must have sufficient rights to read the corresponding nodes.")
        public String similarityIndexQuery() default "/jcr:root/oak:index//* [@useInSimilarity = true]";

        @AttributeDefinition(name="Cache time-to-live in seconds", description="The results of expensive operations like queries are cached for this amount of time")
        public int cacheLifetimeSeconds() default 60;
    }
}

