/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.io.Closeable;
import java.util.Hashtable;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.apache.sling.distribution.journal.JournalAvailable;
import org.apache.sling.distribution.journal.MessageSender;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.impl.discovery.DiscoveryService;
import org.apache.sling.distribution.journal.impl.publisher.MessagingCacheCallback;
import org.apache.sling.distribution.journal.messages.ClearCommand;
import org.apache.sling.distribution.journal.queue.PubQueueProvider;
import org.apache.sling.distribution.journal.queue.PubQueueProviderFactory;
import org.apache.sling.distribution.journal.shared.DistributionMetricsService;
import org.apache.sling.distribution.journal.shared.Topics;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class PubQueueProviderPublisher {
    @Reference
    private MessagingProvider messagingProvider;
    @Reference
    private DiscoveryService discoveryService;
    @Reference
    private Topics topics;
    @Reference
    JournalAvailable journalAvailable;
    @Reference
    private DistributionMetricsService distributionMetricsService;
    @Reference
    private PubQueueProviderFactory pubQueueProviderFactory;
    private PubQueueProvider pubQueueProvider;
    private ServiceRegistration<PubQueueProvider> reg;

    @Activate
    public void activate(BundleContext context) {
        MessageSender commandSender = this.messagingProvider.createSender(this.topics.getCommandTopic());
        MessagingCacheCallback callback = new MessagingCacheCallback(this.messagingProvider, this.topics.getPackageTopic(), this.distributionMetricsService, this.discoveryService, (Consumer<ClearCommand>)commandSender);
        this.pubQueueProvider = this.pubQueueProviderFactory.create(callback);
        this.reg = context.registerService(PubQueueProvider.class, (Object)this.pubQueueProvider, new Hashtable());
    }

    @Deactivate
    public void deactivate() {
        IOUtils.closeQuietly((Closeable)this.pubQueueProvider);
        this.reg.unregister();
    }
}

