/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.list.AbstractLinkedList;
import org.apache.jackrabbit.jcr2spi.hierarchy.ChildNodeEntries;
import org.apache.jackrabbit.jcr2spi.hierarchy.EntryFactory;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChildNodeEntriesImpl
implements ChildNodeEntries {
    private static Logger log = LoggerFactory.getLogger(ChildNodeEntriesImpl.class);
    private boolean complete = false;
    private final LinkedEntries entries = new LinkedEntries();
    private final NameMap entriesByName = new NameMap();
    private final NodeEntry parent;
    private final EntryFactory factory;

    ChildNodeEntriesImpl(NodeEntry parent, EntryFactory factory, Iterator<ChildInfo> childNodeInfos) {
        this.parent = parent;
        this.factory = factory;
        if (childNodeInfos != null) {
            while (childNodeInfos.hasNext()) {
                ChildInfo ci = childNodeInfos.next();
                NodeEntry entry = factory.createNodeEntry(parent, ci.getName(), ci.getUniqueID());
                this.add(entry, ci.getIndex());
            }
            this.complete = true;
        } else {
            this.complete = false;
        }
    }

    NodeEntry getNext(NodeEntry childEntry) {
        LinkedEntries.LinkNode ln = this.entries.getLinkNode(childEntry);
        LinkedEntries.LinkNode nextLn = ln == null ? null : ln.getNextLinkNode();
        return nextLn == null ? null : nextLn.getNodeEntry();
    }

    NodeEntry getPrevious(NodeEntry childEntry) {
        LinkedEntries.LinkNode ln = this.entries.getLinkNode(childEntry);
        LinkedEntries.LinkNode prevLn = ln == null ? null : ln.getPreviousLinkNode();
        return prevLn == null ? null : prevLn.getNodeEntry();
    }

    @Override
    public boolean isComplete() {
        return this.parent.getStatus() != 0 && this.complete || this.parent.getStatus() == 4 || Status.isTerminal(this.parent.getStatus());
    }

    @Override
    public synchronized void reload() throws ItemNotFoundException, RepositoryException {
        if (this.isComplete()) {
            return;
        }
        NodeId id = this.parent.getWorkspaceId();
        Iterator<ChildInfo> childNodeInfos = this.factory.getItemStateFactory().getChildNodeInfos(id);
        this.update(childNodeInfos);
    }

    synchronized void update(Iterator<ChildInfo> childNodeInfos) {
        LinkedEntries.LinkNode prevLN = null;
        while (childNodeInfos.hasNext()) {
            ChildInfo ci = childNodeInfos.next();
            LinkedEntries.LinkNode ln = this.entriesByName.getLinkNode(ci.getName(), ci.getIndex(), ci.getUniqueID());
            if (ln == null) {
                NodeEntry entry = this.factory.createNodeEntry(this.parent, ci.getName(), ci.getUniqueID());
                ln = this.internalAddAfter(entry, ci.getIndex(), prevLN);
            } else if (prevLN != null) {
                if (prevLN != ln) {
                    this.reorderAfter(ln, prevLN);
                } else {
                    log.error("ChildInfo iterator contains multiple entries with the same name|index or uniqueID -> ignore ChildNodeInfo.");
                }
            }
            prevLN = ln;
        }
        this.complete = true;
    }

    @Override
    public Iterator<NodeEntry> iterator() {
        ArrayList<NodeEntry> l = new ArrayList<NodeEntry>(this.entries.size());
        Iterator it = this.entries.linkNodeIterator();
        while (it.hasNext()) {
            l.add(((LinkedEntries.LinkNode)((Object)it.next())).getNodeEntry());
        }
        return Collections.unmodifiableList(l).iterator();
    }

    @Override
    public List<NodeEntry> get(Name nodeName) {
        return this.entriesByName.getList(nodeName);
    }

    @Override
    public NodeEntry get(Name nodeName, int index) {
        if (index < 1) {
            throw new IllegalArgumentException("index is 1-based");
        }
        return this.entriesByName.getNodeEntry(nodeName, index);
    }

    @Override
    public NodeEntry get(Name nodeName, String uniqueID) {
        if (uniqueID == null || nodeName == null) {
            throw new IllegalArgumentException();
        }
        for (NodeEntry cne : this.get(nodeName)) {
            if (!uniqueID.equals(cne.getUniqueID())) continue;
            return cne;
        }
        return null;
    }

    @Override
    public synchronized void add(NodeEntry cne) {
        this.internalAdd(cne, 0);
    }

    @Override
    public synchronized void add(NodeEntry cne, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Invalid index" + index);
        }
        this.internalAdd(cne, index);
    }

    @Override
    public synchronized void add(NodeEntry entry, int index, NodeEntry beforeEntry) {
        if (beforeEntry != null) {
            LinkedEntries.LinkNode beforeLN = this.entries.getLinkNode(beforeEntry);
            if (beforeLN == null) {
                throw new NoSuchElementException();
            }
            LinkedEntries.LinkNode insertLN = this.internalAdd(entry, index);
            this.reorder(entry.getName(), insertLN, beforeLN);
        } else {
            this.add(entry);
        }
    }

    private LinkedEntries.LinkNode internalAdd(NodeEntry entry, int index) {
        Name nodeName = entry.getName();
        LinkedEntries.LinkNode existing = null;
        if (index >= 1) {
            existing = this.entriesByName.getLinkNode(nodeName, index);
        }
        for (int i = 1; i < index; ++i) {
            LinkedEntries.LinkNode previous = this.entriesByName.getLinkNode(nodeName, i);
            if (previous != null) continue;
            NodeEntry sibling = this.factory.createNodeEntry(this.parent, nodeName, null);
            this.internalAdd(sibling, i);
        }
        LinkedEntries.LinkNode ln = this.entries.add(entry, index);
        this.entriesByName.put(nodeName, index, ln);
        if (existing != null) {
            this.reorder(nodeName, ln, existing);
        }
        return ln;
    }

    private LinkedEntries.LinkNode internalAddAfter(NodeEntry newEntry, int index, LinkedEntries.LinkNode insertAfter) {
        LinkedEntries.LinkNode ln = this.entries.addAfter(newEntry, index, insertAfter);
        this.entriesByName.put(newEntry.getName(), index, ln);
        return ln;
    }

    @Override
    public synchronized NodeEntry remove(NodeEntry childEntry) {
        LinkedEntries.LinkNode ln = this.entries.removeNodeEntry(childEntry);
        if (ln != null) {
            this.entriesByName.remove(childEntry.getName(), ln);
            return childEntry;
        }
        return null;
    }

    @Override
    public synchronized NodeEntry reorder(NodeEntry insertEntry, NodeEntry beforeEntry) {
        LinkedEntries.LinkNode beforeLN;
        LinkedEntries.LinkNode insertLN = this.entries.getLinkNode(insertEntry);
        if (insertLN == null) {
            throw new NoSuchElementException();
        }
        LinkedEntries.LinkNode linkNode = beforeLN = beforeEntry != null ? this.entries.getLinkNode(beforeEntry) : null;
        if (beforeEntry != null && beforeLN == null) {
            throw new NoSuchElementException();
        }
        NodeEntry previousBefore = insertLN.getNextLinkNode().getNodeEntry();
        if (previousBefore != beforeEntry) {
            this.reorder(insertEntry.getName(), insertLN, beforeLN);
        }
        return previousBefore;
    }

    @Override
    public void reorderAfter(NodeEntry insertEntry, NodeEntry afterEntry) {
        LinkedEntries.LinkNode afterLN;
        LinkedEntries.LinkNode insertLN = this.entries.getLinkNode(insertEntry);
        if (insertLN == null) {
            throw new NoSuchElementException();
        }
        LinkedEntries.LinkNode linkNode = afterLN = afterEntry != null ? this.entries.getLinkNode(afterEntry) : null;
        if (afterEntry != null && afterLN == null) {
            throw new NoSuchElementException();
        }
        LinkedEntries.LinkNode previousLN = insertLN.getPreviousLinkNode();
        if (previousLN != afterLN) {
            this.reorderAfter(insertLN, afterLN);
        }
    }

    private void reorder(Name insertName, LinkedEntries.LinkNode insertLN, LinkedEntries.LinkNode beforeLN) {
        if (this.entriesByName.containsSiblings(insertName)) {
            int position;
            if (beforeLN == null) {
                position = -1;
            } else {
                LinkedEntries.LinkNode ln;
                position = 0;
                Iterator it = this.entries.linkNodeIterator();
                while (it.hasNext() && (ln = (LinkedEntries.LinkNode)((Object)it.next())) != beforeLN) {
                    if (ln == insertLN || !insertName.equals(ln.qName)) continue;
                    ++position;
                }
            }
            this.entriesByName.reorder(insertName, insertLN, position);
        }
        this.entries.reorderNode(insertLN, beforeLN);
    }

    private void reorderAfter(LinkedEntries.LinkNode insertLN, LinkedEntries.LinkNode afterLN) {
        LinkedEntries.LinkNode currentAfter;
        if (insertLN == null) {
            throw new NoSuchElementException();
        }
        if (afterLN == null) {
            afterLN = this.entries.getHeader();
        }
        if ((currentAfter = afterLN.getNextLinkNode()) == insertLN) {
            log.debug("Already ordered behind 'afterEntry'.");
            return;
        }
        Name insertName = insertLN.qName;
        if (this.entriesByName.containsSiblings(insertName)) {
            int position = -1;
            if (afterLN == this.entries.getHeader()) {
                position = 0;
            } else {
                position = 0;
                Iterator it = this.entries.linkNodeIterator();
                while (it.hasNext()) {
                    LinkedEntries.LinkNode ln = (LinkedEntries.LinkNode)((Object)it.next());
                    if (insertName.equals(ln.qName) && ln != insertLN) {
                        ++position;
                    }
                    if (ln != afterLN) continue;
                    break;
                }
            }
            this.entriesByName.reorder(insertName, insertLN, position);
        }
        this.entries.reorderNode(insertLN, currentAfter);
    }

    private static class NameMap {
        private final Map<Name, List<LinkedEntries.LinkNode>> snsMap = new HashMap<Name, List<LinkedEntries.LinkNode>>();
        private final Map<Name, LinkedEntries.LinkNode> nameMap = new HashMap<Name, LinkedEntries.LinkNode>();

        private NameMap() {
        }

        public boolean containsSiblings(Name qName) {
            return this.snsMap.containsKey(qName);
        }

        private Object get(Name qName) {
            LinkedEntries.LinkNode val = this.nameMap.get(qName);
            if (val != null) {
                return val.getNodeEntry();
            }
            List<LinkedEntries.LinkNode> l = this.snsMap.get(qName);
            if (l != null) {
                ArrayList<NodeEntry> nodeEntries = new ArrayList<NodeEntry>(l.size());
                for (LinkedEntries.LinkNode ln : l) {
                    nodeEntries.add(ln.getNodeEntry());
                }
                return nodeEntries;
            }
            return null;
        }

        public List<NodeEntry> getList(Name name) {
            Object obj = this.get(name);
            if (obj == null) {
                return Collections.emptyList();
            }
            if (obj instanceof List) {
                ArrayList l = new ArrayList((List)obj);
                return Collections.unmodifiableList(l);
            }
            return Collections.singletonList((NodeEntry)obj);
        }

        public NodeEntry getNodeEntry(Name name, int index) {
            Object obj = this.get(name);
            if (obj == null) {
                return null;
            }
            if (obj instanceof List) {
                return NameMap.findMatchingEntry((List)obj, index);
            }
            if (index == 1) {
                return (NodeEntry)obj;
            }
            return null;
        }

        public LinkedEntries.LinkNode getLinkNode(Name name, int index) {
            if (index < 1) {
                throw new IllegalArgumentException("Illegal index " + index);
            }
            LinkedEntries.LinkNode val = this.nameMap.get(name);
            if (val != null) {
                return index == 1 ? val : null;
            }
            List<LinkedEntries.LinkNode> l = this.snsMap.get(name);
            int pos = index - 1;
            return l != null && pos < l.size() ? l.get(pos) : null;
        }

        public LinkedEntries.LinkNode getLinkNode(Name name, int index, String uniqueID) {
            if (uniqueID != null) {
                LinkedEntries.LinkNode val = this.nameMap.get(name);
                if (val != null) {
                    if (uniqueID.equals(val.getNodeEntry().getUniqueID())) {
                        return val;
                    }
                } else {
                    List<LinkedEntries.LinkNode> l = this.snsMap.get(name);
                    if (l != null) {
                        for (LinkedEntries.LinkNode ln : l) {
                            if (!uniqueID.equals(ln.getNodeEntry().getUniqueID())) continue;
                            return ln;
                        }
                    }
                }
            }
            return this.getLinkNode(name, index);
        }

        public void put(Name name, int index, LinkedEntries.LinkNode value) {
            List<Object> l;
            LinkedEntries.LinkNode single = this.nameMap.remove(name);
            if (single != null) {
                l = new ArrayList<LinkedEntries.LinkNode>();
                l.add((Object)single);
                this.snsMap.put(name, l);
            } else {
                l = this.snsMap.get(name);
            }
            if (l == null) {
                this.nameMap.put(name, value);
            } else {
                int position = index - 1;
                if (position < 0 || position > l.size()) {
                    l.add((Object)value);
                } else {
                    l.add(position, (Object)value);
                }
            }
        }

        public LinkedEntries.LinkNode remove(Name name, LinkedEntries.LinkNode value) {
            List<LinkedEntries.LinkNode> l;
            LinkedEntries.LinkNode rm = this.nameMap.remove(name);
            if (rm == null && (l = this.snsMap.get(name)) != null && l.remove((Object)value)) {
                rm = value;
            }
            return rm;
        }

        public void reorder(Name name, LinkedEntries.LinkNode insertValue, int position) {
            List<LinkedEntries.LinkNode> sns = this.snsMap.get(name);
            if (sns == null) {
                return;
            }
            sns.remove((Object)insertValue);
            if (position < 0 || position > sns.size()) {
                sns.add(insertValue);
            } else {
                sns.add(position, insertValue);
            }
        }

        private static NodeEntry findMatchingEntry(List<NodeEntry> siblings, int index) {
            if (index > siblings.size()) {
                return null;
            }
            return siblings.get(index - 1);
        }
    }

    private final class LinkedEntries
    extends AbstractLinkedList {
        LinkedEntries() {
            this.init();
        }

        private LinkNode getLinkNode(NodeEntry nodeEntry) {
            Iterator<LinkNode> it = this.linkNodeIterator();
            while (it.hasNext()) {
                LinkNode ln = it.next();
                if (ln.getNodeEntry() != nodeEntry) continue;
                return ln;
            }
            return null;
        }

        private LinkNode getHeader() {
            return (LinkNode)this.header;
        }

        LinkNode add(NodeEntry cne, int index) {
            LinkNode ln = new LinkNode(cne, index);
            this.addNode(ln, this.header);
            return ln;
        }

        LinkNode addAfter(NodeEntry cne, int index, LinkNode insertAfter) {
            LinkNode newNode;
            if (insertAfter == null) {
                newNode = new LinkNode(cne, index);
                this.addNode(newNode, this.header);
            } else if (insertAfter.getNextLinkNode() == null) {
                newNode = this.add(cne, index);
            } else {
                newNode = new LinkNode(cne, index);
                this.addNode(newNode, insertAfter.getNextLinkNode());
            }
            return newNode;
        }

        LinkNode removeNodeEntry(NodeEntry cne) {
            LinkNode ln = this.getLinkNode(cne);
            if (ln != null) {
                ln.remove();
            }
            return ln;
        }

        void reorderNode(LinkNode insert, LinkNode before) {
            this.removeNode(insert);
            if (before == null) {
                this.addNode(insert, this.header);
            } else {
                this.addNode(insert, before);
            }
        }

        protected AbstractLinkedList.Node createNode(Object value) {
            return new LinkNode(value, 1);
        }

        protected AbstractLinkedList.Node createHeaderNode() {
            return new LinkNode();
        }

        private Iterator<LinkNode> linkNodeIterator() {
            return new LinkNodeIterator();
        }

        private class LinkNodeIterator
        implements Iterator<LinkNode> {
            private LinkNode next;
            private final int expectedModCount;

            private LinkNodeIterator() {
                this.next = ((LinkNode)LinkedEntries.this.header).getNextLinkNode();
                this.expectedModCount = LinkedEntries.this.modCount;
            }

            @Override
            public boolean hasNext() {
                this.checkModCount();
                return this.next != LinkedEntries.this.header;
            }

            @Override
            public LinkNode next() {
                this.checkModCount();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                LinkNode n = this.next;
                this.next = this.next.getNextLinkNode();
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            private void checkModCount() {
                if (this.expectedModCount != LinkedEntries.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        private final class LinkNode
        extends AbstractLinkedList.Node {
            private final Name qName;

            protected LinkNode() {
                this.qName = null;
            }

            protected LinkNode(Object value, int index) {
                super(index > 1 ? value : new SoftReference<Object>(value));
                this.qName = ((NodeEntry)value).getName();
            }

            protected void setValue(Object value) {
                throw new UnsupportedOperationException("Not implemented");
            }

            protected Object getValue() {
                Object val = super.getValue();
                NodeEntry ne = val == null ? null : (val instanceof Reference ? (NodeEntry)((Reference)val).get() : (NodeEntry)val);
                if (ne == null && this != LinkedEntries.this.header) {
                    ne = ChildNodeEntriesImpl.this.factory.createNodeEntry(ChildNodeEntriesImpl.this.parent, this.qName, null);
                    super.setValue(new SoftReference<NodeEntry>(ne));
                }
                return ne;
            }

            public NodeEntry getNodeEntry() {
                return (NodeEntry)this.getValue();
            }

            public void remove() {
                LinkedEntries.this.removeNode(this);
            }

            public LinkNode getNextLinkNode() {
                return (LinkNode)super.getNextNode();
            }

            public LinkNode getPreviousLinkNode() {
                return (LinkNode)super.getPreviousNode();
            }
        }
    }
}

