/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.spi2dav;

import java.io.IOException;
import relocated_for_contentpackage.javax.jcr.PropertyType;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Value;
import relocated_for_contentpackage.javax.jcr.ValueFactory;
import relocated_for_contentpackage.org.apache.jackrabbit.commons.webdav.ValueUtil;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.Path;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.PropertyId;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.PropertyInfo;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.QValue;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.QValueFactory;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.NameException;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.value.ValueFormat;
import relocated_for_contentpackage.org.apache.jackrabbit.spi2dav.ItemInfoImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.property.DavProperty;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.property.DavPropertySet;

public class PropertyInfoImpl
extends ItemInfoImpl
implements PropertyInfo {
    private final PropertyId id;
    private int type;
    private boolean isMultiValued;
    private QValue[] values;

    public PropertyInfoImpl(PropertyId id, Path path, int type, boolean isMultiValued, QValue[] values) {
        super(path);
        this.id = id;
        this.type = type;
        this.isMultiValued = isMultiValued;
        this.values = values;
    }

    public PropertyInfoImpl(PropertyId id, DavPropertySet propSet, NamePathResolver resolver, ValueFactory valueFactory, QValueFactory qValueFactory) throws RepositoryException, IOException, NameException {
        super(propSet, resolver);
        this.id = id;
        String typeName = propSet.get("type", ItemResourceConstants.NAMESPACE).getValue().toString();
        this.type = PropertyType.valueFromName(typeName);
        DavProperty<?> prop = propSet.get("value", ItemResourceConstants.NAMESPACE);
        if (prop != null) {
            Value[] jcrValues = ValueUtil.valuesFromXml(prop.getValue(), this.type, valueFactory);
            if (jcrValues == null || jcrValues.length == 0) {
                this.values = QValue.EMPTY_ARRAY;
            } else {
                QValue qv = this.type == 2 ? qValueFactory.create(jcrValues[0].getStream()) : ValueFormat.getQValue(jcrValues[0], resolver, qValueFactory);
                this.values = new QValue[]{qv};
            }
        } else {
            this.isMultiValued = true;
            prop = propSet.get("values", ItemResourceConstants.NAMESPACE);
            if (prop == null) {
                throw new RepositoryException("Item with id " + id.toString() + " doesn't represent a valid property.");
            }
            Value[] jcrValues = ValueUtil.valuesFromXml(prop.getValue(), this.type, valueFactory);
            this.values = new QValue[jcrValues.length];
            for (int i = 0; i < jcrValues.length; ++i) {
                this.values[i] = this.type == 2 ? qValueFactory.create(jcrValues[i].getStream()) : ValueFormat.getQValue(jcrValues[i], resolver, qValueFactory);
            }
        }
    }

    @Override
    public boolean denotesNode() {
        return false;
    }

    @Override
    public PropertyId getId() {
        return this.id;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    @Override
    public QValue[] getValues() {
        return this.values;
    }
}

