/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.principalbased;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.security.AccessControlEntry;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.AccessControlObserver;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLEditor;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLTemplate;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntriesCache
extends AccessControlObserver
implements AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(EntriesCache.class);
    private final SessionImpl systemSession;
    private final ACLEditor systemEditor;
    private final String repPolicyName;
    private final Map<Object, List<AccessControlEntry>> cache;
    private final Object monitor = new Object();

    EntriesCache(SessionImpl systemSession, ACLEditor systemEditor, String accessControlRootPath) throws RepositoryException {
        this.systemSession = systemSession;
        this.systemEditor = systemEditor;
        this.repPolicyName = systemSession.getJCRName(N_POLICY);
        this.cache = new LRUMap(1000);
        ObservationManager observationMgr = systemSession.getWorkspace().getObservationManager();
        int events = 19;
        String[] ntNames = new String[]{systemSession.getJCRName(NT_REP_ACCESS_CONTROLLABLE), systemSession.getJCRName(NT_REP_ACL), systemSession.getJCRName(NT_REP_ACE)};
        observationMgr.addEventListener((EventListener)this, events, accessControlRootPath, true, null, ntNames, false);
    }

    @Override
    protected void close() {
        super.close();
        try {
            this.systemSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException e) {
            log.error("Unexpected error while closing CachingEntryCollector", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AccessControlEntry> getEntries(Collection<Principal> principals) throws RepositoryException {
        List<AccessControlEntry> entries;
        String key = EntriesCache.getCacheKey(principals);
        Object object = this.monitor;
        synchronized (object) {
            entries = this.cache.get(key);
            if (entries == null) {
                entries = new ArrayList<AccessControlEntry>();
                for (Principal p : principals) {
                    ACLTemplate acl = this.systemEditor.getACL(p);
                    if (acl == null || acl.isEmpty()) continue;
                    AccessControlEntry[] aces = acl.getAccessControlEntries();
                    entries.addAll(Arrays.asList(aces));
                }
                this.cache.put(key, entries);
            }
        }
        return entries;
    }

    private static String getCacheKey(Collection<Principal> principals) {
        StringBuilder sb = new StringBuilder();
        for (Principal p : principals) {
            sb.append(p.getName()).append('/');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onEvent(EventIterator events) {
        HashMap<String, Integer> modMap = new HashMap<String, Integer>();
        block10: while (events.hasNext()) {
            try {
                Event ev = events.nextEvent();
                String identifier = ev.getIdentifier();
                String path = ev.getPath();
                switch (ev.getType()) {
                    case 1: {
                        NodeImpl n = (NodeImpl)this.systemSession.getNodeByIdentifier(identifier);
                        if (n.isNodeType(NT_REP_ACL)) {
                            modMap.put(Text.getRelativeParent((String)path, (int)1), 1);
                            break;
                        }
                        if (!n.isNodeType(NT_REP_ACE)) break;
                        modMap.put(Text.getRelativeParent((String)path, (int)2), 4);
                        break;
                    }
                    case 2: {
                        NodeImpl parent;
                        String parentPath = Text.getRelativeParent((String)path, (int)1);
                        if (this.systemSession.nodeExists(parentPath)) {
                            parent = (NodeImpl)this.systemSession.getNode(parentPath);
                            if (this.repPolicyName.equals(Text.getName((String)path))) {
                                modMap.put(parentPath, 2);
                                break;
                            }
                            if (!parent.isNodeType(NT_REP_ACL)) continue block10;
                            modMap.put(Text.getRelativeParent((String)path, (int)2), 4);
                            break;
                        }
                        log.debug("Cannot process NODE_REMOVED event. Parent " + parentPath + " doesn't exist (anymore).");
                        break;
                    }
                    case 16: {
                        NodeImpl parent = (NodeImpl)this.systemSession.getNodeByIdentifier(identifier);
                        if (!parent.isNodeType(NT_REP_ACE)) break;
                        modMap.put(Text.getRelativeParent((String)path, (int)3), 4);
                        break;
                    }
                }
            }
            catch (RepositoryException e) {
                log.warn("Internal error: {}", (Object)e.getMessage());
            }
        }
        if (!modMap.isEmpty()) {
            Object object = this.monitor;
            synchronized (object) {
                this.cache.clear();
            }
            this.notifyListeners(new AccessControlModifications(modMap));
        }
    }
}

