/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.mongodb.resourceprovider.impl;

import aQute.bnd.annotation.component.Deactivate;
import com.mongodb.MongoClient;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.nosql.generic.adapter.MetricsNoSqlAdapterWrapper;
import org.apache.sling.nosql.generic.adapter.NoSqlAdapter;
import org.apache.sling.nosql.generic.resource.AbstractNoSqlResourceProviderFactory;
import org.apache.sling.nosql.mongodb.resourceprovider.impl.MongoDBNoSqlAdapter;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, name="org.apache.sling.nosql.mongodb.resourceprovider.MongoDBNoSqlResourceProviderFactory.factory.config", label="Apache Sling NoSQL MongoDB Resource Provider Factory", description="Defines a resource provider factory with MongoDB persistence.", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={ResourceProviderFactory.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Root paths: {provider.roots}"})
public final class MongoDBNoSqlResourceProviderFactory
extends AbstractNoSqlResourceProviderFactory {
    @Property(label="Root paths", description="Root paths for resource provider.", cardinality=0x7FFFFFFF)
    static final String PROVIDER_ROOTS_PROPERTY = "provider.roots";
    @Property(label="Connection String", description="MongoDB connection String. Example: 'localhost:27017,localhost:27018,localhost:27019'", value={"localhost:27017"})
    static final String CONNECTION_STRING_PROPERTY = "connectionString";
    private static final String CONNECTION_STRING_DEFAULT = "localhost:27017";
    @Property(label="Database", description="MongoDB database to store resource data in.", value={"sling"})
    static final String DATABASE_PROPERTY = "database";
    private static final String DATABASE_DEFAULT = "sling";
    @Property(label="Collection", description="MongoDB collection to store resource data in.", value={"resources"})
    static final String COLLECTION_PROPERTY = "collection";
    private static final String COLLECTION_DEFAULT = "resources";
    @Reference
    private EventAdmin eventAdmin;
    private MongoClient mongoClient;
    private NoSqlAdapter noSqlAdapter;

    @Activate
    private void activate(ComponentContext componentContext, Map<String, Object> config) {
        String connectionString = PropertiesUtil.toString((Object)config.get(CONNECTION_STRING_PROPERTY), (String)CONNECTION_STRING_DEFAULT);
        String database = PropertiesUtil.toString((Object)config.get(DATABASE_PROPERTY), (String)DATABASE_DEFAULT);
        String collection = PropertiesUtil.toString((Object)config.get(COLLECTION_PROPERTY), (String)COLLECTION_DEFAULT);
        this.mongoClient = new MongoClient(connectionString);
        MongoDBNoSqlAdapter mongodbAdapter = new MongoDBNoSqlAdapter(this.mongoClient, database, collection);
        this.noSqlAdapter = new MetricsNoSqlAdapterWrapper((NoSqlAdapter)mongodbAdapter, LoggerFactory.getLogger(MongoDBNoSqlAdapter.class));
    }

    @Deactivate
    private void deactivate() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    protected NoSqlAdapter getNoSqlAdapter() {
        return this.noSqlAdapter;
    }

    protected EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

