/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.internal;

import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

public final class KeyTemplateProtoConverter {
    public static KeyTemplate.OutputPrefixType prefixFromProto(OutputPrefixType outputPrefixType) throws GeneralSecurityException {
        switch (outputPrefixType) {
            case TINK: {
                return KeyTemplate.OutputPrefixType.TINK;
            }
            case LEGACY: {
                return KeyTemplate.OutputPrefixType.LEGACY;
            }
            case RAW: {
                return KeyTemplate.OutputPrefixType.RAW;
            }
            case CRUNCHY: {
                return KeyTemplate.OutputPrefixType.CRUNCHY;
            }
        }
        throw new GeneralSecurityException("Unknown output prefix type");
    }

    private static OutputPrefixType prefixToProto(KeyTemplate.OutputPrefixType outputPrefixType) throws GeneralSecurityException {
        switch (outputPrefixType) {
            case TINK: {
                return OutputPrefixType.TINK;
            }
            case LEGACY: {
                return OutputPrefixType.LEGACY;
            }
            case RAW: {
                return OutputPrefixType.RAW;
            }
            case CRUNCHY: {
                return OutputPrefixType.CRUNCHY;
            }
        }
        throw new GeneralSecurityException("Unknown output prefix type");
    }

    public static com.google.crypto.tink.proto.KeyTemplate toProto(KeyTemplate keyTemplate) throws GeneralSecurityException {
        return com.google.crypto.tink.proto.KeyTemplate.newBuilder().setTypeUrl(keyTemplate.getTypeUrl()).setValue(ByteString.copyFrom((byte[])keyTemplate.getValue())).setOutputPrefixType(KeyTemplateProtoConverter.prefixToProto(keyTemplate.getOutputPrefixType())).build();
    }

    public static byte[] toByteArray(KeyTemplate keyTemplate) throws GeneralSecurityException {
        return KeyTemplateProtoConverter.toProto(keyTemplate).toByteArray();
    }

    public static KeyTemplate fromProto(com.google.crypto.tink.proto.KeyTemplate proto) throws GeneralSecurityException {
        return KeyTemplate.create(proto.getTypeUrl(), proto.getValue().toByteArray(), KeyTemplateProtoConverter.prefixFromProto(proto.getOutputPrefixType()));
    }

    public static KeyTemplate fromByteArray(byte[] bytes) throws GeneralSecurityException {
        try {
            com.google.crypto.tink.proto.KeyTemplate proto = com.google.crypto.tink.proto.KeyTemplate.parseFrom(bytes, ExtensionRegistryLite.getEmptyRegistry());
            return KeyTemplateProtoConverter.fromProto(proto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("invalid key template", e);
        }
    }

    private KeyTemplateProtoConverter() {
    }
}

