/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public final class VectorSerializeRow<T extends SerializeWrite> {
    private T serializeWrite;
    private ObjectInspector.Category[] categories;
    private PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories;
    private int[] outputColumnNums;
    private boolean hasAnyNulls;
    private boolean isAllNulls;

    public VectorSerializeRow(T serializeWrite) {
        this();
        this.serializeWrite = serializeWrite;
    }

    private VectorSerializeRow() {
    }

    public void init(List<String> typeNames, int[] columnMap) throws HiveException {
        int size = typeNames.size();
        this.categories = new ObjectInspector.Category[size];
        this.primitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[size];
        this.outputColumnNums = Arrays.copyOf(columnMap, size);
        for (int i = 0; i < size; ++i) {
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeNames.get(i));
            this.categories[i] = typeInfo.getCategory();
            if (this.categories[i] != ObjectInspector.Category.PRIMITIVE) continue;
            this.primitiveCategories[i] = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        }
    }

    public void init(List<String> typeNames) throws HiveException {
        int size = typeNames.size();
        this.categories = new ObjectInspector.Category[size];
        this.primitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[size];
        this.outputColumnNums = new int[size];
        for (int i = 0; i < size; ++i) {
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeNames.get(i));
            this.categories[i] = typeInfo.getCategory();
            if (this.categories[i] == ObjectInspector.Category.PRIMITIVE) {
                this.primitiveCategories[i] = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
            }
            this.outputColumnNums[i] = i;
        }
    }

    public void init(TypeInfo[] typeInfos, int[] columnMap) throws HiveException {
        int size = typeInfos.length;
        this.categories = new ObjectInspector.Category[size];
        this.primitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[size];
        this.outputColumnNums = Arrays.copyOf(columnMap, size);
        for (int i = 0; i < typeInfos.length; ++i) {
            TypeInfo typeInfo = typeInfos[i];
            this.categories[i] = typeInfo.getCategory();
            if (this.categories[i] != ObjectInspector.Category.PRIMITIVE) continue;
            this.primitiveCategories[i] = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        }
    }

    public int getCount() {
        return this.categories.length;
    }

    public void setOutput(ByteStream.Output output) {
        this.serializeWrite.set(output);
    }

    public void setOutputAppend(ByteStream.Output output) {
        this.serializeWrite.setAppend(output);
    }

    public void serializeWrite(VectorizedRowBatch batch, int batchIndex) throws IOException {
        this.hasAnyNulls = false;
        this.isAllNulls = true;
        int size = this.categories.length;
        block19: for (int i = 0; i < size; ++i) {
            ColumnVector colVector = batch.cols[this.outputColumnNums[i]];
            int adjustedBatchIndex = colVector.isRepeating ? 0 : batchIndex;
            if (!colVector.noNulls && colVector.isNull[adjustedBatchIndex]) {
                this.serializeWrite.writeNull();
                this.hasAnyNulls = true;
                continue;
            }
            this.isAllNulls = false;
            switch (this.categories[i]) {
                case PRIMITIVE: {
                    switch (this.primitiveCategories[i]) {
                        case BOOLEAN: {
                            this.serializeWrite.writeBoolean(((LongColumnVector)colVector).vector[adjustedBatchIndex] != 0L);
                            continue block19;
                        }
                        case BYTE: {
                            this.serializeWrite.writeByte((byte)((LongColumnVector)colVector).vector[adjustedBatchIndex]);
                            continue block19;
                        }
                        case SHORT: {
                            this.serializeWrite.writeShort((short)((LongColumnVector)colVector).vector[adjustedBatchIndex]);
                            continue block19;
                        }
                        case INT: {
                            this.serializeWrite.writeInt((int)((LongColumnVector)colVector).vector[adjustedBatchIndex]);
                            continue block19;
                        }
                        case LONG: {
                            this.serializeWrite.writeLong(((LongColumnVector)colVector).vector[adjustedBatchIndex]);
                            continue block19;
                        }
                        case DATE: {
                            this.serializeWrite.writeDate((int)((LongColumnVector)colVector).vector[adjustedBatchIndex]);
                            continue block19;
                        }
                        case TIMESTAMP: {
                            this.serializeWrite.writeTimestamp(((TimestampColumnVector)colVector).asScratchTimestamp(adjustedBatchIndex));
                            continue block19;
                        }
                        case FLOAT: {
                            this.serializeWrite.writeFloat((float)((DoubleColumnVector)colVector).vector[adjustedBatchIndex]);
                            continue block19;
                        }
                        case DOUBLE: {
                            this.serializeWrite.writeDouble(((DoubleColumnVector)colVector).vector[adjustedBatchIndex]);
                            continue block19;
                        }
                        case STRING: 
                        case CHAR: 
                        case VARCHAR: {
                            BytesColumnVector bytesColVector = (BytesColumnVector)colVector;
                            this.serializeWrite.writeString(bytesColVector.vector[adjustedBatchIndex], bytesColVector.start[adjustedBatchIndex], bytesColVector.length[adjustedBatchIndex]);
                            continue block19;
                        }
                        case BINARY: {
                            BytesColumnVector bytesColVector = (BytesColumnVector)colVector;
                            this.serializeWrite.writeBinary(bytesColVector.vector[adjustedBatchIndex], bytesColVector.start[adjustedBatchIndex], bytesColVector.length[adjustedBatchIndex]);
                            continue block19;
                        }
                        case DECIMAL: {
                            DecimalColumnVector decimalColVector = (DecimalColumnVector)colVector;
                            this.serializeWrite.writeHiveDecimal(decimalColVector.vector[adjustedBatchIndex], (int)decimalColVector.scale);
                            continue block19;
                        }
                        case INTERVAL_YEAR_MONTH: {
                            this.serializeWrite.writeHiveIntervalYearMonth((int)((LongColumnVector)colVector).vector[adjustedBatchIndex]);
                            continue block19;
                        }
                        case INTERVAL_DAY_TIME: {
                            this.serializeWrite.writeHiveIntervalDayTime(((IntervalDayTimeColumnVector)colVector).asScratchIntervalDayTime(adjustedBatchIndex));
                            continue block19;
                        }
                    }
                    throw new RuntimeException("Unexpected primitive category " + this.primitiveCategories[i]);
                }
                default: {
                    throw new RuntimeException("Unexpected category " + this.categories[i]);
                }
            }
        }
    }

    public boolean getHasAnyNulls() {
        return this.hasAnyNulls;
    }

    public boolean getIsAllNulls() {
        return this.isAllNulls;
    }
}

