/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vector;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!\u0002\r\u001a\u0001e\u0019\u0003\u0002C\u0017\u0001\u0005\u000b\u0007I\u0011A\u0018\t\u0011M\u0002!\u0011!Q\u0001\nAB\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005m!I!\b\u0001BC\u0002\u0013\u0005\u0011d\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005y!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003D\u0011!9\u0005A!b\u0001\n\u0003\u0011\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011%\u0003!Q1A\u0005\u0002)C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\u0007!\u0002!\t!G)\t\u000fa\u0003!\u0019!C\u00013\"1Q\f\u0001Q\u0001\niCQA\u0018\u0001\u0005\u0002}CQA\u001a\u0001\u0005\u0002\u001dDQa\u001c\u0001\u0005\u0002ADQa\u001c\u0001\u0005\nMDq!a\u0002\u0001\t\u0003\tI\u0001\u0003\u0004g\u0001\u0011%\u0011q\u0002\u0005\u0007M\u0002!I!a\u0007\t\r\u0005E\u0002\u0001\"\u0001K\u0005I\u0019E.^:uKJLgn\u001a+sK\u0016tu\u000eZ3\u000b\u0005iY\u0012AC2mkN$XM]5oO*\u0011A$H\u0001\u0006[2d\u0017N\u0019\u0006\u0003=}\tQa\u001d9be.T!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sON\u0019\u0001\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g!\t)3&\u0003\u0002-M\ta1+\u001a:jC2L'0\u00192mK\u0006)\u0011N\u001c3fq\u000e\u0001Q#\u0001\u0019\u0011\u0005\u0015\n\u0014B\u0001\u001a'\u0005\rIe\u000e^\u0001\u0007S:$W\r\u001f\u0011\u0002\tML'0Z\u000b\u0002mA\u0011QeN\u0005\u0003q\u0019\u0012A\u0001T8oO\u0006)1/\u001b>fA\u0005q1-\u001a8uKJ<\u0016\u000e\u001e5O_JlW#\u0001\u001f\u0011\u0005urT\"A\r\n\u0005}J\"A\u0004,fGR|'oV5uQ:{'/\\\u0001\u0010G\u0016tG/\u001a:XSRDgj\u001c:nA\u0005!1m\\:u+\u0005\u0019\u0005CA\u0013E\u0013\t)eE\u0001\u0004E_V\u0014G.Z\u0001\u0006G>\u001cH\u000fI\u0001\u0007Q\u0016Lw\r\u001b;\u0002\u000f!,\u0017n\u001a5uA\u0005A1\r[5mIJ,g.F\u0001L!\r)CJT\u0005\u0003\u001b\u001a\u0012Q!\u0011:sCf\u0004\"!\u0010\u0001\u0002\u0013\rD\u0017\u000e\u001c3sK:\u0004\u0013A\u0002\u001fj]&$h\bF\u0004O%N#VKV,\t\u000b5j\u0001\u0019\u0001\u0019\t\u000bQj\u0001\u0019\u0001\u001c\t\u000bij\u0001\u0019\u0001\u001f\t\u000b\u0005k\u0001\u0019A\"\t\u000b\u001dk\u0001\u0019A\"\t\u000b%k\u0001\u0019A&\u0002\r%\u001cH*Z1g+\u0005Q\u0006CA\u0013\\\u0013\tafEA\u0004C_>dW-\u00198\u0002\u000f%\u001cH*Z1gA\u000511-\u001a8uKJ,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003Gn\ta\u0001\\5oC2<\u0017BA3c\u0005\u00191Vm\u0019;pe\u00069\u0001O]3eS\u000e$Hc\u0001\u0019iU\")\u0011.\u0005a\u0001A\u0006)\u0001o\\5oi\")1.\u0005a\u0001Y\u0006yA-[:uC:\u001cW-T3bgV\u0014X\r\u0005\u0002>[&\u0011a.\u0007\u0002\u0010\t&\u001cH/\u00198dK6+\u0017m];sK\u0006Y\u0001O]3eS\u000e$\b+\u0019;i)\rY\u0015O\u001d\u0005\u0006SJ\u0001\r\u0001\u0019\u0005\u0006WJ\u0001\r\u0001\u001c\u000b\u0006i\u0006\u0005\u0011Q\u0001\t\u0004kvteB\u0001<|\u001d\t9(0D\u0001y\u0015\tIh&\u0001\u0004=e>|GOP\u0005\u0002O%\u0011APJ\u0001\ba\u0006\u001c7.Y4f\u0013\tqxP\u0001\u0003MSN$(B\u0001?'\u0011\u0019\t\u0019a\u0005a\u0001y\u0005i\u0001o\\5oi^KG\u000f\u001b(pe6DQa[\nA\u00021\f1bY8naV$XmQ8tiR)1)a\u0003\u0002\u000e!)\u0011\u000e\u0006a\u0001A\")1\u000e\u0006a\u0001YR1\u0011\u0011CA\f\u00033\u0001R!JA\na\rK1!!\u0006'\u0005\u0019!V\u000f\u001d7fe!1\u00111A\u000bA\u0002qBQa[\u000bA\u00021$\u0002\"!\u0005\u0002\u001e\u0005}\u0011\u0011\u0005\u0005\u0007\u0003\u00071\u0002\u0019\u0001\u001f\t\u000b\u00053\u0002\u0019A\"\t\u000b-4\u0002\u0019\u00017)\u0007Y\t)\u0003\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tYCJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0018\u0003S\u0011q\u0001^1jYJ,7-A\u0005mK\u00064gj\u001c3fg\"*\u0001!!\u000e\u0002@A!\u0011qGA\u001e\u001b\t\tIDC\u0002\u0002,uIA!!\u0010\u0002:\t)1+\u001b8dK\u0006\u0012\u0011\u0011I\u0001\u0006c92d\u0006\r")
public class ClusteringTreeNode
implements Serializable {
    private final int index;
    private final long size;
    private final VectorWithNorm centerWithNorm;
    private final double cost;
    private final double height;
    private final ClusteringTreeNode[] children;
    private final boolean isLeaf;

    public int index() {
        return this.index;
    }

    public long size() {
        return this.size;
    }

    public VectorWithNorm centerWithNorm() {
        return this.centerWithNorm;
    }

    public double cost() {
        return this.cost;
    }

    public double height() {
        return this.height;
    }

    public ClusteringTreeNode[] children() {
        return this.children;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public Vector center() {
        return this.centerWithNorm().vector();
    }

    public int predict(Vector point, DistanceMeasure distanceMeasure) {
        Tuple2<Object, Object> tuple2 = this.predict(new VectorWithNorm(point), distanceMeasure);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int index = tuple2._1$mcI$sp();
        int index2 = index;
        return index2;
    }

    public ClusteringTreeNode[] predictPath(Vector point, DistanceMeasure distanceMeasure) {
        return (ClusteringTreeNode[])this.predictPath(new VectorWithNorm(point), distanceMeasure).toArray(ClassTag$.MODULE$.apply(ClusteringTreeNode.class));
    }

    private List<ClusteringTreeNode> predictPath(VectorWithNorm pointWithNorm, DistanceMeasure distanceMeasure) {
        ClusteringTreeNode selected;
        if (this.isLeaf()) {
            ClusteringTreeNode clusteringTreeNode = this;
            return Nil$.MODULE$.$colon$colon((Object)clusteringTreeNode);
        }
        ClusteringTreeNode clusteringTreeNode = selected = (ClusteringTreeNode)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.children())).minBy((Function1 & java.io.Serializable & Serializable)child -> BoxesRunTime.boxToDouble((double)distanceMeasure.distance(((ClusteringTreeNode)child).centerWithNorm(), pointWithNorm)), (Ordering)Ordering.Double$.MODULE$);
        return selected.predictPath(pointWithNorm, distanceMeasure).$colon$colon((Object)clusteringTreeNode);
    }

    public double computeCost(Vector point, DistanceMeasure distanceMeasure) {
        Tuple2<Object, Object> tuple2 = this.predict(new VectorWithNorm(point), distanceMeasure);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double cost = tuple2._2$mcD$sp();
        double cost2 = cost;
        return cost2;
    }

    private Tuple2<Object, Object> predict(VectorWithNorm pointWithNorm, DistanceMeasure distanceMeasure) {
        return this.predict(pointWithNorm, distanceMeasure.cost(this.centerWithNorm(), pointWithNorm), distanceMeasure);
    }

    private Tuple2<Object, Object> predict(VectorWithNorm pointWithNorm, double cost, DistanceMeasure distanceMeasure) {
        while (!this_.isLeaf()) {
            double minCost;
            Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this_.children())).map((Function1 & java.io.Serializable & Serializable)child -> new Tuple2(child, (Object)BoxesRunTime.boxToDouble((double)distanceMeasure.cost(child.centerWithNorm(), pointWithNorm))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).minBy((Function1 & java.io.Serializable & Serializable)x$12 -> BoxesRunTime.boxToDouble((double)x$12._2$mcD$sp()), (Ordering)Ordering.Double$.MODULE$);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ClusteringTreeNode selectedChild = (ClusteringTreeNode)tuple2._1();
            double minCost2 = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)selectedChild, (Object)BoxesRunTime.boxToDouble((double)minCost2));
            ClusteringTreeNode selectedChild2 = (ClusteringTreeNode)tuple22._1();
            cost = minCost = tuple22._2$mcD$sp();
            ClusteringTreeNode this_ = selectedChild2;
        }
        return new Tuple2.mcID.sp(this_.index(), cost);
    }

    public ClusteringTreeNode[] leafNodes() {
        if (this.isLeaf()) {
            return (ClusteringTreeNode[])((Object[])new ClusteringTreeNode[]{this});
        }
        return (ClusteringTreeNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.children())).flatMap((Function1 & java.io.Serializable & Serializable)x$14 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ClusteringTreeNode)x$14).leafNodes())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ClusteringTreeNode.class)));
    }

    public ClusteringTreeNode(int index, long size, VectorWithNorm centerWithNorm, double cost, double height, ClusteringTreeNode[] children) {
        this.index = index;
        this.size = size;
        this.centerWithNorm = centerWithNorm;
        this.cost = cost;
        this.height = height;
        this.children = children;
        this.isLeaf = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])children)).isEmpty();
        Predef$.MODULE$.require(this.isLeaf() && index >= 0 || !this.isLeaf() && index < 0);
    }
}

