/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.IsNaN$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns true if `expr` is NaN, or false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(cast('NaN' as double));\n       true\n  ", since="1.5.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\r\u001a\u0001\u001aB\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!)\u0001\t\u0001C\u0001\u0003\")A\t\u0001C!\u000b\")\u0001\f\u0001C!3\")Q\f\u0001C!=\")\u0001\u000e\u0001C!S\")q\u000f\u0001C)q\"91\u0010AA\u0001\n\u0003a\bb\u0002@\u0001#\u0003%\ta \u0005\n\u0003+\u0001\u0011\u0011!C!\u0003/A\u0011\"!\u000b\u0001\u0003\u0003%\t!a\u000b\t\u0013\u0005M\u0002!!A\u0005\u0002\u0005U\u0002\"CA\u001e\u0001\u0005\u0005I\u0011IA\u001f\u0011%\tY\u0005AA\u0001\n\u0003\ti\u0005C\u0005\u0002R\u0001\t\t\u0011\"\u0011\u0002T\u001dI\u0011qO\r\u0002\u0002#\u0005\u0011\u0011\u0010\u0004\t1e\t\t\u0011#\u0001\u0002|!1\u0001I\u0005C\u0001\u0003\u0013C\u0011\"a#\u0013\u0003\u0003%)%!$\t\u0013\u0005=%#!A\u0005\u0002\u0006E\u0005\"CAK%\u0005\u0005I\u0011QAL\u0011%\t\u0019KEA\u0001\n\u0013\t)KA\u0003Jg:\u000bgJ\u0003\u0002\u001b7\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\taR$\u0001\u0005dCR\fG._:u\u0015\tqr$A\u0002tc2T!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\u0019\u0001qe\u000b\u00182oA\u0011\u0001&K\u0007\u00023%\u0011!&\u0007\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0001\u0006L\u0005\u0003[e\u0011\u0011\u0002\u0015:fI&\u001c\u0017\r^3\u0011\u0005!z\u0013B\u0001\u0019\u001a\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$a\u0002)s_\u0012,8\r\u001e\t\u0003eaJ!!O\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003q\u0002\"\u0001K\u001f\n\u0005yJ\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDC\u0001\"D!\tA\u0003\u0001C\u0003;\u0007\u0001\u0007A(\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0012\t\u0004\u000f>\u0013fB\u0001%N\u001d\tIE*D\u0001K\u0015\tYU%\u0001\u0004=e>|GOP\u0005\u0002i%\u0011ajM\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0016KA\u0002TKFT!AT\u001a\u0011\u0005M3V\"\u0001+\u000b\u0005Uk\u0012!\u0002;za\u0016\u001c\u0018BA,U\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f+\u0005Q\u0006C\u0001\u001a\\\u0013\ta6GA\u0004C_>dW-\u00198\u0002\t\u00154\u0018\r\u001c\u000b\u0003?\n\u0004\"A\r1\n\u0005\u0005\u001c$aA!os\"91M\u0002I\u0001\u0002\u0004!\u0017!B5oaV$\bCA3g\u001b\u0005Y\u0012BA4\u001c\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,Gc\u00016qkB\u00111N\\\u0007\u0002Y*\u0011Q.G\u0001\bG>$WmZ3o\u0013\tyGN\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015\tx\u00011\u0001s\u0003\r\u0019G\u000f\u001f\t\u0003WNL!\u0001\u001e7\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")ao\u0002a\u0001U\u0006\u0011QM^\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0005\tK\b\"\u0002>\t\u0001\u0004a\u0014\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0003\u0005vDqAO\u0005\u0011\u0002\u0003\u0007A(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005!f\u0001\u001f\u0002\u0004-\u0012\u0011Q\u0001\t\u0005\u0003\u000f\t\t\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0010M\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019\"!\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00033\u0001B!a\u0007\u0002&5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0003mC:<'BAA\u0012\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0012Q\u0004\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u00055\u0002c\u0001\u001a\u00020%\u0019\u0011\u0011G\u001a\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007}\u000b9\u0004C\u0005\u0002:5\t\t\u00111\u0001\u0002.\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0010\u0011\u000b\u0005\u0005\u0013qI0\u000e\u0005\u0005\r#bAA#g\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00131\t\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002[\u0003\u001fB\u0001\"!\u000f\u0010\u0003\u0003\u0005\raX\u0001\u0007KF,\u0018\r\\:\u0015\u0007i\u000b)\u0006\u0003\u0005\u0002:A\t\t\u00111\u0001`QM\u0001\u0011\u0011LA0\u0003C\n)'a\u001a\u0002l\u00055\u0014\u0011OA:!\rA\u00131L\u0005\u0004\u0003;J\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003G\n\u0011i\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011ueV,\u0007%\u001b4!A\u0016D\bO\u001d1!SN\u0004c*\u0019(-A=\u0014\bEZ1mg\u0016\u0004s\u000e\u001e5fe^L7/\u001a\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u001b\u0002\u0017*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3-Y:uQ\u001dr\u0015MT\u0014!CN\u0004Cm\\;cY\u0016L\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005=\u0014!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAA;\u0003=\u0001(/\u001a3jG\u0006$Xm\u00184v]\u000e\u001c\u0018!B%t\u001d\u0006t\u0005C\u0001\u0015\u0013'\u0011\u0011\u0012QP\u001c\u0011\r\u0005}\u0014Q\u0011\u001fC\u001b\t\t\tIC\u0002\u0002\u0004N\nqA];oi&lW-\u0003\u0003\u0002\b\u0006\u0005%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011\u0011\u0011P\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011D\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0005\u0006M\u0005\"\u0002\u001e\u0016\u0001\u0004a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u00033\u000by\n\u0005\u00033\u00037c\u0014bAAOg\t1q\n\u001d;j_:D\u0001\"!)\u0017\u0003\u0003\u0005\rAQ\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a*\u0011\t\u0005m\u0011\u0011V\u0005\u0005\u0003W\u000biB\u0001\u0004PE*,7\r\u001e")
public class IsNaN
extends UnaryExpression
implements Predicate,
ImplicitCastInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(IsNaN isNaN) {
        return IsNaN$.MODULE$.unapply(isNaN);
    }

    public static <A> Function1<Expression, A> andThen(Function1<IsNaN, A> function1) {
        return IsNaN$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, IsNaN> compose(Function1<A, Expression> function1) {
        return IsNaN$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public DataType dataType() {
        return Predicate.dataType$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Object value = this.child().eval(input);
        if (value == null) {
            return BoxesRunTime.boxToBoolean((boolean)false);
        }
        DataType dataType = this.child().dataType();
        if (DoubleType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToBoolean((boolean)Double.isNaN(BoxesRunTime.unboxToDouble((Object)value)));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToBoolean((boolean)Float.isNaN(BoxesRunTime.unboxToFloat((Object)value)));
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval = this.child().genCode(ctx);
        DataType dataType = this.child().dataType();
        if (DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType)) {
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          ", " ", " = ", ";\n          ", " = !", " && Double.isNaN(", ");"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.value(), eval.isNull(), eval.value()})), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public IsNaN withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public IsNaN copy(Expression child) {
        return new IsNaN(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "IsNaN";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IsNaN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IsNaN)) return false;
        boolean bl = true;
        if (!bl) return false;
        IsNaN isNaN = (IsNaN)x$1;
        Expression expression = this.child();
        Expression expression2 = isNaN.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!isNaN.canEqual(this)) return false;
        return true;
    }

    public IsNaN(Expression child) {
        this.child = child;
        Predicate.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

