/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitOrAgg$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the bitwise OR of all non-null input values, or null if none.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (3), (5) AS tab(col);\n       7\n  ", group="agg_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001\u0002\f\u0018\u0001\u001aB\u0001\u0002\u000e\u0001\u0003\u0016\u0004%\t!\u000e\u0005\tu\u0001\u0011\t\u0012)A\u0005m!)1\b\u0001C\u0001y!)q\b\u0001C!\u0001\")A\n\u0001C!\u001b\")Q\u000b\u0001C)-\"9\u0011\fAA\u0001\n\u0003Q\u0006b\u0002/\u0001#\u0003%\t!\u0018\u0005\bQ\u0002\t\t\u0011\"\u0011j\u0011\u001d\t\b!!A\u0005\u0002IDqA\u001e\u0001\u0002\u0002\u0013\u0005q\u000fC\u0004~\u0001\u0005\u0005I\u0011\t@\t\u0013\u0005-\u0001!!A\u0005\u0002\u00055\u0001\"CA\f\u0001\u0005\u0005I\u0011IA\r\u000f%\tidFA\u0001\u0012\u0003\tyD\u0002\u0005\u0017/\u0005\u0005\t\u0012AA!\u0011\u0019Y\u0004\u0003\"\u0001\u0002P!I\u0011\u0011\u000b\t\u0002\u0002\u0013\u0015\u00131\u000b\u0005\n\u0003+\u0002\u0012\u0011!CA\u0003/B\u0011\"a\u0017\u0011\u0003\u0003%\t)!\u0018\t\u0013\u0005%\u0004#!A\u0005\n\u0005-$\u0001\u0003\"ji>\u0013\u0018iZ4\u000b\u0005aI\u0012!C1hOJ,w-\u0019;f\u0015\tQ2$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u000f\u001e\u0003!\u0019\u0017\r^1msN$(B\u0001\u0010 \u0003\r\u0019\u0018\u000f\u001c\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u00011\u0003\u0002\u0001(WE\u0002\"\u0001K\u0015\u000e\u0003]I!AK\f\u0003\u0019\tKG/Q4he\u0016<\u0017\r^3\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\u000fA\u0013x\u000eZ;diB\u0011AFM\u0005\u0003g5\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u00195jY\u0012,\u0012A\u000e\t\u0003oaj\u0011!G\u0005\u0003se\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"!\u0010 \u0011\u0005!\u0002\u0001\"\u0002\u001b\u0004\u0001\u00041\u0014\u0001\u00038pI\u0016t\u0015-\\3\u0016\u0003\u0005\u0003\"AQ%\u000f\u0005\r;\u0005C\u0001#.\u001b\u0005)%B\u0001$&\u0003\u0019a$o\\8u}%\u0011\u0001*L\u0001\u0007!J,G-\u001a4\n\u0005)[%AB*ue&twM\u0003\u0002I[\u0005Y!-\u001b;Pa\u0016\u0014\u0018\r^8s)\rq\u0015k\u0015\t\u0003o=K!\u0001U\r\u0003!\tKg.\u0019:z\u0003JLG\u000f[7fi&\u001c\u0007\"\u0002*\u0006\u0001\u00041\u0014\u0001\u00027fMRDQ\u0001V\u0003A\u0002Y\nQA]5hQR\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGCA\u001fX\u0011\u0015Af\u00011\u00017\u0003!qWm^\"iS2$\u0017\u0001B2paf$\"!P.\t\u000fQ:\u0001\u0013!a\u0001m\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00010+\u0005Yz6&\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017!C;oG\",7m[3e\u0015\t)W&\u0001\u0006b]:|G/\u0019;j_:L!a\u001a2\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002UB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\u0005Y\u0006twMC\u0001p\u0003\u0011Q\u0017M^1\n\u0005)c\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#A:\u0011\u00051\"\u0018BA;.\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\tA8\u0010\u0005\u0002-s&\u0011!0\f\u0002\u0004\u0003:L\bb\u0002?\f\u0003\u0003\u0005\ra]\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003}\u0004R!!\u0001\u0002\bal!!a\u0001\u000b\u0007\u0005\u0015Q&\u0001\u0006d_2dWm\u0019;j_:LA!!\u0003\u0002\u0004\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty!!\u0006\u0011\u00071\n\t\"C\u0002\u0002\u00145\u0012qAQ8pY\u0016\fg\u000eC\u0004}\u001b\u0005\u0005\t\u0019\u0001=\u0002\r\u0015\fX/\u00197t)\u0011\ty!a\u0007\t\u000fqt\u0011\u0011!a\u0001q\"\u001a\u0002!a\b\u0002&\u0005\u001d\u00121FA\u0017\u0003c\t\u0019$a\u000e\u0002:A\u0019q'!\t\n\u0007\u0005\r\u0012DA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005%\u0012\u0001V0G+:\u001bu\fK3yaJL\u0003%\f\u0011SKR,(O\\:!i\",\u0007EY5uo&\u001cX\rI(SA=4\u0007%\u00197mA9|g.\f8vY2\u0004\u0013N\u001c9vi\u00022\u0018\r\\;fg2\u0002sN\u001d\u0011ok2d\u0007%\u001b4!]>tWML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qF\u0001X\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aw\u000e\\\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u00154S1\u0002\u0003&N\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00118\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAA\u001b\u0003%\twmZ0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002<\u0005)1G\f\u0019/a\u0005A!)\u001b;Pe\u0006;w\r\u0005\u0002)!M!\u0001#a\u00112!\u0019\t)%a\u00137{5\u0011\u0011q\t\u0006\u0004\u0003\u0013j\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003\u001b\n9EA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!a\u0010\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A[\u0001\u0006CB\u0004H.\u001f\u000b\u0004{\u0005e\u0003\"\u0002\u001b\u0014\u0001\u00041\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003?\n)\u0007\u0005\u0003-\u0003C2\u0014bAA2[\t1q\n\u001d;j_:D\u0001\"a\u001a\u0015\u0003\u0003\u0005\r!P\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u001c\u0011\u0007-\fy'C\u0002\u0002r1\u0014aa\u00142kK\u000e$\b")
public class BitOrAgg
extends BitAggregate {
    private final Expression child;

    public static Option<Expression> unapply(BitOrAgg bitOrAgg) {
        return BitOrAgg$.MODULE$.unapply(bitOrAgg);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitOrAgg, A> function1) {
        return BitOrAgg$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, BitOrAgg> compose(Function1<A, Expression> function1) {
        return BitOrAgg$.MODULE$.compose(function1);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public String nodeName() {
        return "bit_or";
    }

    @Override
    public BinaryArithmetic bitOperator(Expression left, Expression right) {
        return new BitwiseOr(left, right);
    }

    @Override
    public BitOrAgg withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public BitOrAgg copy(Expression child) {
        return new BitOrAgg(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitOrAgg";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitOrAgg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitOrAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitOrAgg bitOrAgg = (BitOrAgg)x$1;
        Expression expression = this.child();
        Expression expression2 = bitOrAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitOrAgg.canEqual(this)) return false;
        return true;
    }

    public BitOrAgg(Expression child) {
        this.child = child;
    }
}

