/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.clustering.GaussianMixture;
import org.apache.spark.mllib.clustering.GaussianMixtureModel;
import org.apache.spark.mllib.linalg.Vectors;

public class JavaGaussianMixtureExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaGaussianMixtureExample");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        String path = "data/mllib/gmm_data.txt";
        JavaRDD data = jsc.textFile(path);
        JavaRDD parsedData = data.map((Function & Serializable)s -> {
            String[] sarray = s.trim().split(" ");
            double[] values = new double[sarray.length];
            for (int i = 0; i < sarray.length; ++i) {
                values[i] = Double.parseDouble(sarray[i]);
            }
            return Vectors.dense((double[])values);
        });
        parsedData.cache();
        GaussianMixtureModel gmm = new GaussianMixture().setK(2).run(parsedData.rdd());
        gmm.save(jsc.sc(), "target/org/apache/spark/JavaGaussianMixtureExample/GaussianMixtureModel");
        GaussianMixtureModel sameModel = GaussianMixtureModel.load((SparkContext)jsc.sc(), (String)"target/org.apache.spark.JavaGaussianMixtureExample/GaussianMixtureModel");
        for (int j = 0; j < gmm.k(); ++j) {
            System.out.printf("weight=%f\nmu=%s\nsigma=\n%s\n", gmm.weights()[j], gmm.gaussians()[j].mu(), gmm.gaussians()[j].sigma());
        }
        jsc.stop();
    }
}

