/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application.cli;

import org.apache.flink.annotation.Internal;
import org.apache.flink.client.cli.ApplicationDeployer;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.ClusterClientServiceLoader;
import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.application.ApplicationConfiguration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ApplicationClusterDeployer
implements ApplicationDeployer {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationClusterDeployer.class);
    private final ClusterClientServiceLoader clientServiceLoader;

    public ApplicationClusterDeployer(ClusterClientServiceLoader clientServiceLoader) {
        this.clientServiceLoader = (ClusterClientServiceLoader)Preconditions.checkNotNull((Object)clientServiceLoader);
    }

    @Override
    public <ClusterID> void run(Configuration configuration, ApplicationConfiguration applicationConfiguration) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)applicationConfiguration);
        LOG.info("Submitting application in 'Application Mode'.");
        ClusterClientFactory clientFactory = this.clientServiceLoader.getClusterClientFactory(configuration);
        try (ClusterDescriptor clusterDescriptor = clientFactory.createClusterDescriptor(configuration);){
            ClusterSpecification clusterSpecification = clientFactory.getClusterSpecification(configuration);
            clusterDescriptor.deployApplicationCluster(clusterSpecification, applicationConfiguration);
        }
    }
}

