/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.streampark.common.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class FileUtils$ {
    public static final FileUtils$ MODULE$;

    static {
        new FileUtils$();
    }

    public String org$apache$streampark$common$util$FileUtils$$bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        Predef$.MODULE$.byteArrayOps(src).indices().foreach((Function1)new Serializable(src, stringBuilder){
            public static final long serialVersionUID = 0L;
            private final byte[] src$1;
            private final StringBuilder stringBuilder$1;

            public final StringBuilder apply(int i) {
                int v = this.src$1[i] & 0xFF;
                String hv = Integer.toHexString(v).toUpperCase();
                Object object = hv.length() < 2 ? this.stringBuilder$1.append(0) : BoxedUnit.UNIT;
                return this.stringBuilder$1.append(hv);
            }
            {
                this.src$1 = src$1;
                this.stringBuilder$1 = stringBuilder$1;
            }
        });
        return stringBuilder.toString();
    }

    public boolean isJarFileType(InputStream input2) {
        if (input2 == null) {
            throw new RuntimeException("The inputStream can not be null");
        }
        InputStream x$1 = input2;
        Serializable x$2 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(InputStream in) {
                byte[] b = new byte[4];
                in.read(b, 0, b.length);
                return FileUtils$.MODULE$.org$apache$streampark$common$util$FileUtils$$bytesToHexString(b);
            }
        };
        Utils$.MODULE$.using$default$3(x$1, x$2);
        Object x$3 = null;
        Object r = Utils$.MODULE$.using(x$1, x$2, null);
        String string = "504B0304";
        return !(r != null ? !r.equals(string) : string != null);
    }

    public boolean isJarFileType(File file) {
        if (file.exists() && file.isFile()) {
            return this.isJarFileType(new FileInputStream(file));
        }
        throw new RuntimeException("The file does not exist or the path is a directory");
    }

    public File createTempDir() {
        Object object = new Object();
        try {
            int TEMP_DIR_ATTEMPTS = 10000;
            File baseDir = new File(System.getProperty("java.io.tmpdir"));
            String baseName = new StringBuilder().append(System.currentTimeMillis()).append((Object)"-").toString();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), TEMP_DIR_ATTEMPTS).foreach$mVc$sp((Function1)new Serializable(baseDir, baseName, object){
                public static final long serialVersionUID = 0L;
                private final File baseDir$1;
                private final String baseName$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(int counter) {
                    this.apply$mcVI$sp(counter);
                }

                public void apply$mcVI$sp(int counter) {
                    File tempDir = new File(this.baseDir$1, new StringBuilder().append((Object)this.baseName$1).append((Object)BoxesRunTime.boxToInteger((int)counter)).toString());
                    if (tempDir.mkdir()) {
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)tempDir);
                    }
                }
                {
                    this.baseDir$1 = baseDir$1;
                    this.baseName$1 = baseName$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] Failed to create directory within ", "  attempts (tried ", " 0 to ", " ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)TEMP_DIR_ATTEMPTS), baseName, baseName, BoxesRunTime.boxToInteger((int)(TEMP_DIR_ATTEMPTS - 1))})));
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return (File)nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
    }

    public void exists(String path) {
        Predef$.MODULE$.require(path != null && new StringOps(Predef$.MODULE$.augmentString(path)).nonEmpty() && new File(path).exists(), (Function0)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] FileUtils.exists: file ", " is not exist!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
            }
            {
                this.path$1 = path$1;
            }
        });
    }

    public String getPathFromEnv(String env) {
        String path = System.getenv(env);
        Predef$.MODULE$.require(Utils$.MODULE$.notEmpty(path), (Function0)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final String env$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] FileUtils.getPathFromEnv: ", " is not set on system env"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.env$1}));
            }
            {
                this.env$1 = env$1;
            }
        });
        File file = new File(path);
        Predef$.MODULE$.require(file.exists(), (Function0)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final String env$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] FileUtils.getPathFromEnv: ", " is not exist!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.env$1}));
            }
            {
                this.env$1 = env$1;
            }
        });
        return file.getAbsolutePath();
    }

    public String resolvePath(String parent, String child) {
        File file = new File(parent, child);
        Predef$.MODULE$.require(file.exists(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] FileUtils.resolvePath: ", " is not exist!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1.getAbsolutePath()}));
            }
            {
                this.file$1 = file$1;
            }
        });
        return file.getAbsolutePath();
    }

    public String getSuffix(String filename) {
        Predef$.MODULE$.require(filename != null);
        return (String)new StringOps(Predef$.MODULE$.augmentString(filename)).drop(filename.lastIndexOf("."));
    }

    public List<URL> listFileAsURL(String dirPath) {
        File[] files;
        File file = new File(dirPath);
        List<URL> list = file.exists() && file.isDirectory() ? ((files = file.listFiles()) != null && Predef$.MODULE$.refArrayOps((Object[])files).nonEmpty() ? JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URL apply(File f) {
                return f.toURI().toURL();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)))).toList()) : Collections.emptyList()) : Collections.emptyList();
        return list;
    }

    public boolean equals(File file1, File file2) {
        Tuple2 tuple2;
        block7: {
            int firRead;
            BufferedInputStream second;
            BufferedInputStream first;
            block8: {
                boolean bl;
                block4: {
                    block6: {
                        block5: {
                            block3: {
                                tuple2 = new Tuple2((Object)file1, (Object)file2);
                                if (tuple2 == null) break block3;
                                File a = (File)tuple2._1();
                                File b = (File)tuple2._2();
                                if (a != null && b != null) break block3;
                                bl = false;
                                break block4;
                            }
                            if (tuple2 == null) break block5;
                            File a = (File)tuple2._1();
                            File b = (File)tuple2._2();
                            if (a.exists() && b.exists()) break block5;
                            bl = false;
                            break block4;
                        }
                        if (tuple2 == null) break block6;
                        File a = (File)tuple2._1();
                        File b = (File)tuple2._2();
                        String string = a.getAbsolutePath();
                        String string2 = b.getAbsolutePath();
                        if (string != null ? !string.equals(string2) : string2 != null) break block6;
                        bl = true;
                        break block4;
                    }
                    if (tuple2 == null) break block7;
                    File a = (File)tuple2._1();
                    File b = (File)tuple2._2();
                    first = new BufferedInputStream(new FileInputStream(a));
                    second = new BufferedInputStream(new FileInputStream(b));
                    if (first.available() == second.available()) break block8;
                    bl = false;
                }
                return bl;
            }
            do {
                int secRead;
                if ((firRead = first.read()) == (secRead = second.read())) continue;
                BufferedInputStream x$4 = first;
                BufferedInputStream x$5 = second;
                Function1<Throwable, BoxedUnit> x$6 = Utils$.MODULE$.close$default$2((Seq<AutoCloseable>)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$4, x$5}));
                Utils$.MODULE$.close((Seq<AutoCloseable>)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$4, x$5}), x$6);
                return false;
            } while (firRead != -1);
            BufferedInputStream x$7 = first;
            BufferedInputStream x$8 = second;
            Function1<Throwable, BoxedUnit> x$9 = Utils$.MODULE$.close$default$2((Seq<AutoCloseable>)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$7, x$8}));
            Utils$.MODULE$.close((Seq<AutoCloseable>)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$7, x$8}), x$9);
            return true;
        }
        throw new MatchError((Object)tuple2);
    }

    public String readString(File file) throws IOException {
        Predef$.MODULE$.require(file != null && file.isFile());
        FileReader reader = new FileReader(file);
        Scanner scanner = new Scanner(reader);
        StringBuilder buffer = new StringBuilder();
        Object object = scanner.hasNextLine() ? buffer.append(scanner.nextLine()) : BoxedUnit.UNIT;
        while (scanner.hasNextLine()) {
            buffer.append("\r\n");
            buffer.append(scanner.nextLine());
        }
        Scanner x$10 = scanner;
        FileReader x$11 = reader;
        Function1<Throwable, BoxedUnit> x$12 = Utils$.MODULE$.close$default$2((Seq<AutoCloseable>)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$10, x$11}));
        Utils$.MODULE$.close((Seq<AutoCloseable>)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$10, x$11}), x$12);
        return buffer.toString();
    }

    private FileUtils$() {
        MODULE$ = this;
    }
}

