/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.server.protocol.framed.AbstractFramedStreamSinkChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketMessages;

public abstract class StreamSinkFrameChannel
extends AbstractFramedStreamSinkChannel<WebSocketChannel, StreamSourceFrameChannel, StreamSinkFrameChannel> {
    private final WebSocketFrameType type;
    private int rsv;

    protected StreamSinkFrameChannel(WebSocketChannel channel, WebSocketFrameType type) {
        super(channel);
        this.type = type;
    }

    public int getRsv() {
        return this.rsv;
    }

    public void setRsv(int rsv) {
        if (!this.areExtensionsSupported() && rsv != 0) {
            throw WebSocketMessages.MESSAGES.extensionsNotSupported();
        }
        this.rsv = rsv;
    }

    public boolean isFragmentationSupported() {
        return false;
    }

    public boolean areExtensionsSupported() {
        return false;
    }

    public WebSocketFrameType getType() {
        return this.type;
    }

    public WebSocketChannel getWebSocketChannel() {
        return (WebSocketChannel)this.getChannel();
    }

    @Override
    protected boolean isLastFrame() {
        return this.type == WebSocketFrameType.CLOSE;
    }

    public boolean isFinalFragment() {
        return super.isFinalFrameQueued();
    }
}

