/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy.option;

import com.p6spy.engine.common.ClassHasher;
import com.p6spy.engine.common.CustomHashedHashSet;
import com.p6spy.engine.common.P6Util;
import com.p6spy.engine.logging.Category;
import com.p6spy.engine.spy.P6Factory;
import com.p6spy.engine.spy.option.P6OptionChangedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class P6OptionsRepository {
    private final Map<String, Object> map = new HashMap<String, Object>();
    private Set<DelayedOptionChange> delayedOptionChanges = new HashSet<DelayedOptionChange>();
    private List<P6OptionChangedListener> listeners = new ArrayList<P6OptionChangedListener>();
    private boolean initCompleted = false;

    public void initCompleted() {
        this.initCompleted = true;
        this.fireDelayedOptionChanges();
    }

    public <T> boolean set(Class<T> type, String key, Object value) {
        if (value == null) {
            return false;
        }
        return this.setOrUnSet(type, key, value, null);
    }

    public <T> boolean setOrUnSet(Class<T> type, String key, Object value, Object defaultValue) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key can be neither null nor empty!");
        }
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            this.setInternal(key, value);
        } else {
            this.setInternal(key, this.parse(type, value));
        }
        return true;
    }

    <T> Object parse(Class<T> type, Object value) {
        Object instance;
        if (type.isAssignableFrom(Boolean.class)) {
            return P6Util.isTrue(value.toString(), true);
        }
        if (type.isAssignableFrom(String.class)) {
            return value.toString();
        }
        if (type.isAssignableFrom(Long.class)) {
            return Long.parseLong(value.toString());
        }
        if (type.isAssignableFrom(Integer.class)) {
            return Integer.parseInt(value.toString());
        }
        if (type.isAssignableFrom(Set.class)) {
            throw new IllegalArgumentException("please call the setSet() method instead!");
        }
        if (type.isAssignableFrom(Collection.class) || type.isAssignableFrom(List.class)) {
            throw new IllegalArgumentException("type not supported:" + type.getName());
        }
        if (type.isAssignableFrom(Pattern.class)) {
            return Pattern.compile(value.toString());
        }
        if (type.isAssignableFrom(Category.class)) {
            return new Category(value.toString());
        }
        try {
            instance = P6Util.forName(value.toString()).newInstance();
        }
        catch (Exception ex) {
            try {
                ClassLoader loader = ClassLoader.getSystemClassLoader();
                instance = loader.loadClass(value.toString()).newInstance();
            }
            catch (Exception e) {
                System.err.println("Cannot instantiate " + value + ", even on second attempt. ");
                e.printStackTrace(System.err);
                return null;
            }
        }
        try {
            return instance;
        }
        catch (ClassCastException e) {
            System.err.println("Value " + value + ", is not of expected type. Error: " + e);
            return null;
        }
    }

    void setInternal(String key, Object value) {
        Object oldValue = this.map.put(key, value);
        this.fireOptionChanged(key, oldValue, value);
    }

    public <T> boolean setSet(Class<T> type, String key, String csv) {
        if (csv == null) {
            return false;
        }
        List<String> collection = P6Util.parseCSVList(csv);
        if (collection == null) {
            return false;
        }
        Set<T> oldValue = this.getSet(type, key);
        HashSet newValue = null;
        if (collection.isEmpty()) {
            this.map.remove(key);
        } else {
            newValue = type.equals(P6Factory.class) ? new CustomHashedHashSet(new ClassHasher()) : new HashSet();
            for (String item : collection) {
                if (item.startsWith("-")) {
                    throw new IllegalArgumentException("- prefix has been deprecated for list-like properties! Full overriding happens (see: http://p6spy.github.io/p6spy/2.0/configandusage.html)");
                }
                newValue.add(this.parse(type, item));
            }
            this.map.put(key, newValue);
        }
        this.fireOptionChanged(key, oldValue, newValue);
        return true;
    }

    void fireOptionChanged(String key, Object oldValue, Object newValue) {
        if (this.initCompleted) {
            this.fireDelayedOptionChanges();
            for (P6OptionChangedListener listener : this.listeners) {
                listener.optionChanged(key, oldValue, newValue);
            }
        } else {
            this.delayedOptionChanges.add(new DelayedOptionChange(key, oldValue, newValue));
        }
    }

    private synchronized void fireDelayedOptionChanges() {
        if (null == this.delayedOptionChanges) {
            return;
        }
        for (DelayedOptionChange delayedOption : this.delayedOptionChanges) {
            for (P6OptionChangedListener listener : this.listeners) {
                listener.optionChanged(delayedOption.getKey(), delayedOption.getOldValue(), delayedOption.getNewValue());
            }
        }
        this.delayedOptionChanges = null;
    }

    public <T> T get(Class<T> type, String key) {
        if (!this.initCompleted) {
            throw new IllegalStateException("Options didn't load completely, yet!");
        }
        return (T)this.map.get(key);
    }

    public <T> Set<T> getSet(Class<T> type, String key) {
        return (Set)this.map.get(key);
    }

    public void registerOptionChangedListener(P6OptionChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("P6OptionChangedListener can't be null!");
        }
        this.listeners.add(listener);
    }

    public void unregisterOptionChangedListener(P6OptionChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("P6OptionChangedListener can't be null!");
        }
        this.listeners.remove(listener);
    }

    class DelayedOptionChange {
        private final String key;
        private final Object oldValue;
        private final Object newValue;

        public DelayedOptionChange(String key, Object oldValue, Object newValue) {
            if (null == key || key.isEmpty()) {
                throw new IllegalArgumentException("key can be neither null nor empty!");
            }
            this.key = key;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DelayedOptionChange other = (DelayedOptionChange)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        public String getKey() {
            return this.key;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        private P6OptionsRepository getOuterType() {
            return P6OptionsRepository.this;
        }
    }
}

