/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.synapse.transport.amqp.AMQPTransportException;
import org.apache.synapse.transport.amqp.AMQPTransportMessage;
import org.apache.synapse.transport.amqp.AMQPTransportUtils;

public class AMQPTransportBuffers {
    private BlockingQueue<AMQPTransportMessage> requestBuffer = new LinkedBlockingQueue<AMQPTransportMessage>();
    private BlockingQueue<AMQPTransportMessage> responseBuffer = new LinkedBlockingQueue<AMQPTransportMessage>();

    public List<AMQPTransportMessage> getResponseMessageList(int blockSize) throws AMQPTransportException {
        ArrayList<AMQPTransportMessage> msgList = new ArrayList<AMQPTransportMessage>();
        if (this.responseBuffer.size() > 0) {
            AMQPTransportUtils.moveElements(this.responseBuffer, msgList, blockSize);
        }
        return msgList;
    }

    public void addResponseMessage(AMQPTransportMessage msg) throws InterruptedException {
        this.responseBuffer.put(msg);
    }

    public BlockingQueue<AMQPTransportMessage> getRequestMessageBuffer() {
        return this.requestBuffer;
    }

    public void addRequestMessage(AMQPTransportMessage msg) {
        this.requestBuffer.add(msg);
    }

    public AMQPTransportMessage getRequestMessage() {
        try {
            return this.requestBuffer.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }
}

