/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;

public class AccessLogger {
    private Log log;
    protected SimpleDateFormat fileDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected PrintWriter writer;
    private volatile String dateStamp = "";
    private volatile long rotationLastChecked = 0L;
    private boolean buffered = true;
    private boolean checkExists = false;
    protected File currentLogFile = null;
    protected boolean isRotatable = true;

    public AccessLogger(Log log) {
        this.initOpen();
        this.log = log;
        this.buffered = true;
        this.checkExists = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message) {
        long systemTime;
        if (this.isRotatable && (systemTime = System.currentTimeMillis()) - this.rotationLastChecked > 1000L) {
            AccessLogger accessLogger = this;
            synchronized (accessLogger) {
                if (systemTime - this.rotationLastChecked > 1000L) {
                    this.rotationLastChecked = systemTime;
                    String tsDate = this.fileDateFormatter.format(new Date(systemTime));
                    if (!this.dateStamp.equals(tsDate)) {
                        this.close();
                        this.dateStamp = tsDate;
                        this.open();
                    }
                }
            }
        }
        if (this.checkExists) {
            AccessLogger accessLogger = this;
            synchronized (accessLogger) {
                if (this.currentLogFile != null && !this.currentLogFile.exists()) {
                    try {
                        this.close();
                    }
                    catch (Throwable e) {
                        AccessLogger.handleThrowable(e);
                        this.log.info((Object)"Access Log file Close failed");
                    }
                    this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
                    this.open();
                }
            }
        }
        AccessLogger accessLogger = this;
        synchronized (accessLogger) {
            if (this.writer != null) {
                this.writer.println(message);
                if (!this.buffered) {
                    this.writer.flush();
                }
            }
        }
    }

    protected synchronized void initOpen() {
        this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
        this.open();
    }

    protected synchronized void open() {
        File dir = new File("logs");
        if (!dir.exists() && !dir.mkdirs()) {
            this.log.error((Object)"Access Log Open Directory Failed");
        }
        try {
            String pathName = this.isRotatable ? dir.getAbsolutePath() + File.separator + "http_access_" + this.dateStamp + ".log" : dir.getAbsolutePath() + File.separator + "http_access_" + ".log";
            this.writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(pathName, true), 128000), true);
            this.currentLogFile = new File(pathName);
        }
        catch (IOException e) {
            this.log.warn((Object)"Unable to open the print writer", (Throwable)e);
            this.writer = null;
            this.currentLogFile = null;
        }
    }

    synchronized void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.dateStamp = "";
        this.currentLogFile = null;
    }

    public static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
    }
}

