/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import java.net.InetAddress;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.TransportUtils;

public class NhttpUtil {
    public static String getHostName(InetAddress address) {
        String hostAddress = address.getHostAddress();
        String inetAddr = address.toString();
        int index1 = inetAddr.lastIndexOf(47);
        int index2 = inetAddr.indexOf(hostAddress);
        String result = index2 == index1 + 1 ? (index1 == 0 ? hostAddress : inetAddr.substring(0, index1)) : hostAddress;
        return result;
    }

    public static EndpointReference getDestinationEPR(MessageContext msgContext) {
        String transportURL = (String)msgContext.getProperty("TransportURL");
        if (transportURL != null) {
            return new EndpointReference(transportURL);
        }
        if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            return msgContext.getTo();
        }
        return null;
    }

    public static OMOutputFormat getOMOutputFormat(MessageContext msgContext) {
        OMOutputFormat format = new OMOutputFormat();
        msgContext.setDoingMTOM(TransportUtils.doWriteMTOM((MessageContext)msgContext));
        msgContext.setDoingSwA(TransportUtils.doWriteSwA((MessageContext)msgContext));
        msgContext.setDoingREST(TransportUtils.isDoingREST((MessageContext)msgContext));
        format.setSOAP11(msgContext.isSOAP11());
        format.setDoOptimize(msgContext.isDoingMTOM());
        format.setDoingSWA(msgContext.isDoingSwA());
        format.setCharSetEncoding(TransportUtils.getCharSetEncoding((MessageContext)msgContext));
        Object mimeBoundaryProperty = msgContext.getProperty("mimeBoundary");
        if (mimeBoundaryProperty != null) {
            format.setMimeBoundary((String)mimeBoundaryProperty);
        }
        return format;
    }

    public static String getContentType(MessageContext msgContext) {
        Object contentTypeObject = msgContext.getProperty("ContentType");
        if (contentTypeObject != null) {
            return (String)contentTypeObject;
        }
        if (msgContext.isDoingREST()) {
            return "application/xml";
        }
        return NhttpUtil.getOMOutputFormat(msgContext).getContentType();
    }
}

