/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.ApplicationXMLBuilder;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.MIMEBuilder;
import org.apache.axis2.builder.MTOMBuilder;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.builder.XFormURLEncodedBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.ApplicationXMLFormatter;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.MultipartFormDataFormatter;
import org.apache.axis2.transport.http.SOAPMessageFormatter;
import org.apache.axis2.transport.http.XFormURLEncodedFormatter;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeferredMessageBuilder {
    private static Log log = LogFactory.getLog(DeferredMessageBuilder.class);
    private Map<String, Builder> builders = new HashMap<String, Builder>();
    private Map<String, MessageFormatter> formatters = new HashMap<String, MessageFormatter>();
    public static final String RELAY_FORMATTERS_MAP = "__RELAY_FORMATTERS_MAP";
    public static final String FORCED_RELAY_FORMATTER = "__FORCED_RELAY_FORMATTER";

    public DeferredMessageBuilder() {
        this.builders.put("multipart/related", (Builder)new MIMEBuilder());
        this.builders.put("application/soap+xml", (Builder)new SOAPBuilder());
        this.builders.put("text/xml", (Builder)new SOAPBuilder());
        this.builders.put("application/xop+xml", (Builder)new MTOMBuilder());
        this.builders.put("application/xml", (Builder)new ApplicationXMLBuilder());
        this.builders.put("application/x-www-form-urlencoded", (Builder)new XFormURLEncodedBuilder());
        this.formatters.put("application/x-www-form-urlencoded", (MessageFormatter)new XFormURLEncodedFormatter());
        this.formatters.put("multipart/form-data", (MessageFormatter)new MultipartFormDataFormatter());
        this.formatters.put("application/xml", (MessageFormatter)new ApplicationXMLFormatter());
        this.formatters.put("text/xml", (MessageFormatter)new SOAPMessageFormatter());
        this.formatters.put("application/soap+xml", (MessageFormatter)new SOAPMessageFormatter());
    }

    public Map<String, Builder> getBuilders() {
        return this.builders;
    }

    public Map<String, MessageFormatter> getFormatters() {
        return this.formatters;
    }

    public OMElement getDocument(MessageContext msgCtx, InputStream in) throws XMLStreamException, IOException {
        Builder builder;
        int j;
        String contentType;
        String _contentType = contentType = (String)msgCtx.getProperty("ContentType");
        in = HTTPTransportUtils.handleGZip((MessageContext)msgCtx, (InputStream)in);
        if (contentType != null && (j = contentType.indexOf(";")) > 0) {
            _contentType = contentType.substring(0, j);
        }
        AxisConfiguration configuration = msgCtx.getConfigurationContext().getAxisConfiguration();
        Parameter useFallbackParameter = configuration.getParameter("useDefaultFallbackBuilder");
        boolean useFallbackBuilder = false;
        if (useFallbackParameter != null) {
            useFallbackBuilder = JavaUtils.isTrueExplicitly((Object)useFallbackParameter.getValue(), (boolean)useFallbackBuilder);
        }
        OMElement element = null;
        if (contentType != null && (builder = configuration.getMessageBuilder(_contentType, useFallbackBuilder)) != null) {
            try {
                element = builder.processDocument(in, contentType, msgCtx);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error building message", (Throwable)axisFault);
                throw axisFault;
            }
        }
        if (element == null) {
            if (msgCtx.isDoingREST()) {
                element = BuilderUtil.createPOXBuilder((InputStream)in, null).getDocumentElement();
            } else {
                builder = new SOAPBuilder();
                try {
                    element = builder.processDocument(in, contentType, msgCtx);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)"Error building message using SOAP builder");
                    throw axisFault;
                }
            }
        }
        if (element instanceof SOAPEnvelope) {
            SOAPEnvelope env = (SOAPEnvelope)element;
            env.hasFault();
        }
        if (contentType != null && !contentType.isEmpty()) {
            msgCtx.setProperty("ContentType", (Object)contentType);
        }
        return element;
    }
}

