/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.conn;

import java.io.IOException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.NHttpMessageParserFactory;
import org.apache.http.nio.NHttpMessageWriterFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.synapse.transport.passthru.TargetHandler;

public class SynapseNHttpClientConnection
extends DefaultNHttpClientConnection {
    private boolean markedForRelease = false;

    public SynapseNHttpClientConnection(IOSession session, int bufferSize, int fragmentSizeHint, ByteBufferAllocator allocator, CharsetDecoder charDecoder, CharsetEncoder charEncoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, NHttpMessageParserFactory<HttpResponse> responseParserFactory) {
        super(session, bufferSize, fragmentSizeHint, allocator, charDecoder, charEncoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
    }

    public void close() throws IOException {
        super.close();
    }

    public void shutdown() throws IOException {
        super.shutdown();
    }

    public void submitRequest(HttpRequest request) throws IOException, HttpException {
        super.submitRequest(request);
    }

    public void consumeInput(NHttpClientEventHandler handler) {
        super.consumeInput(handler);
        if (this.markedForRelease && handler instanceof TargetHandler) {
            this.resetState();
            ((TargetHandler)handler).getTargetConfiguration().getConnections().releaseConnection((NHttpClientConnection)this);
        }
    }

    public void produceOutput(NHttpClientEventHandler handler) {
        super.produceOutput(handler);
    }

    public void markForRelease() {
        this.markedForRelease = true;
    }

    private void resetState() {
        this.markedForRelease = false;
    }
}

