/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2BlockingClient;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.DefaultEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.MessageHelper;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class CalloutMediator
extends AbstractMediator
implements ManagedLifecycle {
    private String serviceURL = null;
    private String action = null;
    private String requestKey = null;
    private SynapseXPath requestXPath = null;
    private SynapseXPath targetXPath = null;
    private String targetKey = null;
    private String clientRepository = null;
    private String axis2xml = null;
    private boolean passHeaders = false;
    private boolean initClientOptions = true;
    private boolean securityOn = false;
    private String wsSecPolicyKey = null;
    private String inboundWsSecPolicyKey = null;
    private String outboundWsSecPolicyKey = null;
    private Endpoint endpoint = null;
    private boolean isWrappingEndpointCreated = false;
    private Axis2BlockingClient blockingMsgSender = null;

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Callout mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        try {
            org.apache.axis2.context.MessageContext axis2MsgCtx;
            if (synLog.isTraceOrDebugEnabled()) {
                if (!this.isWrappingEndpointCreated) {
                    synLog.traceOrDebug("Using the defined endpoint : " + this.endpoint.getName());
                } else {
                    if (this.serviceURL != null) {
                        synLog.traceOrDebug("Using the serviceURL : " + this.serviceURL);
                    } else {
                        synLog.traceOrDebug("Using the To header as the EPR ");
                    }
                    if (this.securityOn) {
                        synLog.traceOrDebug("Security enabled within the Callout Mediator config");
                        if (this.wsSecPolicyKey != null) {
                            synLog.traceOrDebug("Using security policy key : " + this.wsSecPolicyKey);
                        } else {
                            if (this.inboundWsSecPolicyKey != null) {
                                synLog.traceOrDebug("Using inbound security policy key : " + this.inboundWsSecPolicyKey);
                            }
                            if (this.outboundWsSecPolicyKey != null) {
                                synLog.traceOrDebug("Using outbound security policy key : " + this.outboundWsSecPolicyKey);
                            }
                        }
                    }
                }
            }
            if ("true".equals((axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext()).getProperty("enableMTOM"))) {
                ((AbstractEndpoint)this.endpoint).getDefinition().setUseMTOM(true);
            }
            MessageContext synapseOutMsgCtx = MessageHelper.cloneMessageContext(synCtx);
            if (this.action != null) {
                synapseOutMsgCtx.setSoapAction(this.action);
            }
            if (this.requestKey != null || this.requestXPath != null) {
                SOAPBody soapBody = synapseOutMsgCtx.getEnvelope().getBody();
                soapBody.removeChildren();
                soapBody.addChild((OMNode)this.getRequestPayload(synCtx));
                if (!this.passHeaders) {
                    SOAPHeader soapHeader = synapseOutMsgCtx.getEnvelope().getHeader();
                    soapHeader.removeChildren();
                }
            }
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("About to invoke the service");
                if (synLog.isTraceTraceEnabled()) {
                    synLog.traceTrace("Request message payload : " + synapseOutMsgCtx.getEnvelope());
                }
            }
            MessageContext resultMsgCtx = null;
            try {
                if ("true".equals(synCtx.getProperty("OUT_ONLY"))) {
                    this.blockingMsgSender.send(this.endpoint, synapseOutMsgCtx);
                } else {
                    resultMsgCtx = this.blockingMsgSender.send(this.endpoint, synapseOutMsgCtx);
                    if ("true".equals(resultMsgCtx.getProperty("blocking.client.error"))) {
                        this.handleFault(synCtx, (Exception)synCtx.getProperty("ERROR_EXCEPTION"));
                    }
                }
            }
            catch (Exception ex) {
                this.handleFault(synCtx, ex);
            }
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Response payload received : " + resultMsgCtx.getEnvelope());
            }
            if (resultMsgCtx != null) {
                if (this.targetXPath != null) {
                    Object o = this.targetXPath.evaluate(synCtx);
                    OMElement result = resultMsgCtx.getEnvelope().getBody().getFirstElement();
                    if (o != null && o instanceof OMElement) {
                        OMElement tgtNode = (OMElement)o;
                        tgtNode.insertSiblingAfter((OMNode)result);
                        tgtNode.detach();
                    } else if (o != null && o instanceof List && !((List)o).isEmpty()) {
                        OMElement tgtNode = (OMElement)((List)o).get(0);
                        tgtNode.insertSiblingAfter((OMNode)result);
                        tgtNode.detach();
                    } else {
                        this.handleException("Evaluation of target XPath expression : " + this.targetXPath.toString() + " did not yeild an OMNode", synCtx);
                    }
                } else if (this.targetKey != null) {
                    OMElement result = resultMsgCtx.getEnvelope().getBody().getFirstElement();
                    synCtx.setProperty(this.targetKey, result);
                } else {
                    synCtx.setEnvelope(resultMsgCtx.getEnvelope());
                }
            } else {
                synLog.traceOrDebug("Service returned a null response");
            }
        }
        catch (AxisFault e) {
            this.handleException("Error invoking service : " + this.serviceURL + (this.action != null ? " with action : " + this.action : ""), (Exception)((Object)e), synCtx);
        }
        catch (JaxenException e) {
            this.handleException("Error while evaluating the XPath expression: " + (Object)((Object)this.targetXPath), (Exception)((Object)e), synCtx);
        }
        synLog.traceOrDebug("End : Callout mediator");
        return true;
    }

    private void handleFault(MessageContext synCtx, Exception ex) {
        synCtx.setProperty("SENDING_FAULT", Boolean.TRUE);
        if (ex instanceof AxisFault) {
            AxisFault axisFault = (AxisFault)((Object)ex);
            if (axisFault.getFaultCodeElement() != null) {
                synCtx.setProperty("ERROR_CODE", axisFault.getFaultCodeElement().getText());
            } else {
                synCtx.setProperty("ERROR_CODE", 401000);
            }
            if (axisFault.getMessage() != null) {
                synCtx.setProperty("ERROR_MESSAGE", axisFault.getMessage());
            } else {
                synCtx.setProperty("ERROR_MESSAGE", "Error while performing the callout operation");
            }
            if (axisFault.getFaultDetailElement() != null) {
                if (axisFault.getFaultDetailElement().getFirstElement() != null) {
                    synCtx.setProperty("ERROR_DETAIL", axisFault.getFaultDetailElement().getFirstElement());
                } else {
                    synCtx.setProperty("ERROR_DETAIL", axisFault.getFaultDetailElement().getText());
                }
            }
        }
        synCtx.setProperty("ERROR_EXCEPTION", ex);
        throw new SynapseException("Error while performing the callout operation", ex);
    }

    private OMElement getRequestPayload(MessageContext synCtx) throws AxisFault {
        if (this.requestKey != null) {
            Object request = synCtx.getProperty(this.requestKey);
            if (request == null) {
                request = synCtx.getEntry(this.requestKey);
            }
            if (request != null && request instanceof OMElement) {
                return (OMElement)request;
            }
            this.handleException("The property : " + this.requestKey + " is not an OMElement", synCtx);
        } else if (this.requestXPath != null) {
            try {
                Object o = this.requestXPath.evaluate(MessageHelper.cloneMessageContext(synCtx));
                if (o instanceof OMElement) {
                    return (OMElement)o;
                }
                if (o instanceof List && !((List)o).isEmpty()) {
                    return (OMElement)((List)o).get(0);
                }
                this.handleException("The evaluation of the XPath expression : " + this.requestXPath.toString() + " did not result in an OMElement", synCtx);
            }
            catch (JaxenException e) {
                this.handleException("Error evaluating XPath expression : " + this.requestXPath.toString(), (Exception)((Object)e), synCtx);
            }
        }
        return null;
    }

    @Override
    public void init(SynapseEnvironment synEnv) {
        this.blockingMsgSender = new Axis2BlockingClient(this.clientRepository, this.axis2xml);
        this.blockingMsgSender.setInitClientOptions(this.initClientOptions);
        EndpointDefinition endpointDefinition = null;
        if (this.serviceURL != null) {
            this.endpoint = new AddressEndpoint();
            endpointDefinition = new EndpointDefinition();
            endpointDefinition.setAddress(this.serviceURL);
            ((AddressEndpoint)this.endpoint).setDefinition(endpointDefinition);
            this.isWrappingEndpointCreated = true;
        } else if (this.endpoint == null) {
            this.endpoint = new DefaultEndpoint();
            endpointDefinition = new EndpointDefinition();
            ((DefaultEndpoint)this.endpoint).setDefinition(endpointDefinition);
            this.isWrappingEndpointCreated = true;
        } else {
            this.endpoint.init(synEnv);
        }
        if (endpointDefinition != null && this.isSecurityOn()) {
            endpointDefinition.setSecurityOn(true);
            if (this.wsSecPolicyKey != null) {
                endpointDefinition.setWsSecPolicyKey(this.wsSecPolicyKey);
            } else {
                if (this.inboundWsSecPolicyKey != null) {
                    endpointDefinition.setInboundWsSecPolicyKey(this.inboundWsSecPolicyKey);
                }
                if (this.outboundWsSecPolicyKey != null) {
                    endpointDefinition.setOutboundWsSecPolicyKey(this.outboundWsSecPolicyKey);
                }
            }
        }
    }

    @Override
    public void destroy() {
        if (!this.isWrappingEndpointCreated) {
            this.endpoint.destroy();
        }
        try {
            this.blockingMsgSender.cleanup();
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getRequestKey() {
        return this.requestKey;
    }

    public void setRequestKey(String requestKey) {
        this.requestKey = requestKey;
    }

    public void setRequestXPath(SynapseXPath requestXPath) throws JaxenException {
        this.requestXPath = requestXPath;
    }

    public void setTargetXPath(SynapseXPath targetXPath) throws JaxenException {
        this.targetXPath = targetXPath;
    }

    public String getTargetKey() {
        return this.targetKey;
    }

    public void setTargetKey(String targetKey) {
        this.targetKey = targetKey;
    }

    public SynapseXPath getRequestXPath() {
        return this.requestXPath;
    }

    public SynapseXPath getTargetXPath() {
        return this.targetXPath;
    }

    public String getClientRepository() {
        return this.clientRepository;
    }

    public void setClientRepository(String clientRepository) {
        this.clientRepository = clientRepository;
    }

    public String getAxis2xml() {
        return this.axis2xml;
    }

    public void setAxis2xml(String axis2xml) {
        this.axis2xml = axis2xml;
    }

    public boolean isPassHeaders() {
        return this.passHeaders;
    }

    public void setPassHeaders(boolean passHeaders) {
        this.passHeaders = passHeaders;
    }

    public boolean isInitClientOptions() {
        return this.initClientOptions;
    }

    public void setInitClientOptions(boolean initClientOptions) {
        this.initClientOptions = initClientOptions;
    }

    public boolean isSecurityOn() {
        return this.securityOn;
    }

    public void setSecurityOn(boolean securityOn) {
        this.securityOn = securityOn;
    }

    public String getWsSecPolicyKey() {
        return this.wsSecPolicyKey;
    }

    public void setWsSecPolicyKey(String wsSecPolicyKey) {
        this.wsSecPolicyKey = wsSecPolicyKey;
    }

    public String getOutboundWsSecPolicyKey() {
        return this.outboundWsSecPolicyKey;
    }

    public void setOutboundWsSecPolicyKey(String outboundWsSecPolicyKey) {
        this.outboundWsSecPolicyKey = outboundWsSecPolicyKey;
    }

    public String getInboundWsSecPolicyKey() {
        return this.inboundWsSecPolicyKey;
    }

    public void setInboundWsSecPolicyKey(String inboundWsSecPolicyKey) {
        this.inboundWsSecPolicyKey = inboundWsSecPolicyKey;
    }

    public Endpoint getEndpoint() {
        if (!this.isWrappingEndpointCreated) {
            return this.endpoint;
        }
        return null;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }
}

