/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.template;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.TemplateParameter;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.eip.EIPUtils;

public class TemplateContext {
    private static final Log log = LogFactory.getLog(TemplateContext.class);
    private String fName;
    private Collection<TemplateParameter> parameters;
    private Map mappedValues;

    public TemplateContext(String name, Collection<TemplateParameter> parameters) {
        this.fName = name;
        this.parameters = parameters;
        this.mappedValues = new HashMap();
    }

    public void setupParams(MessageContext synCtxt) {
        for (TemplateParameter parameter : this.parameters) {
            Object paramValue;
            String mapping = EIPUtils.getTemplatePropertyMapping(this.fName, parameter.getName());
            Object propertyValue = synCtxt.getProperty(mapping);
            if (propertyValue == null && parameter.getDefaultValue() != null) {
                propertyValue = parameter.getDefaultValue();
            }
            if (!parameter.isOptional() && propertyValue == null) {
                String msg = parameter.getName() + " is a required parameter for " + this.fName + " template";
                log.error((Object)msg);
            }
            if ((paramValue = this.getEvaluatedParamValue(synCtxt, parameter.getName(), (Value)propertyValue)) == null) continue;
            this.mappedValues.put(parameter.getName(), paramValue);
            this.removeProperty(synCtxt, mapping);
        }
    }

    private Object getEvaluatedParamValue(MessageContext synCtx, String parameter, Value expression) {
        if (expression != null) {
            if (expression.getExpression() != null) {
                if (expression.hasExprTypeKey()) {
                    if (expression.hasPropertyEvaluateExpr()) {
                        return expression.evalutePropertyExpression(synCtx);
                    }
                    return expression.getExpression();
                }
                return expression.evaluateValue(synCtx);
            }
            if (expression.getKeyValue() != null) {
                return expression.evaluateValue(synCtx);
            }
        }
        return null;
    }

    private void removeProperty(MessageContext synCtxt, String deletedMapping) {
        Set keys = synCtxt.getPropertyKeySet();
        if (keys != null) {
            keys.remove(deletedMapping);
        }
    }

    public Map getMappedValues() {
        return this.mappedValues;
    }

    public void setMappedValues(Map map) {
        this.mappedValues = map;
    }

    public Object getParameterValue(String paramName) {
        return this.mappedValues.get(paramName);
    }

    public String getName() {
        return this.fName;
    }

    public Collection getParameters() {
        return this.parameters;
    }
}

