/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.tasks;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.task.Task;
import org.apache.synapse.util.PayloadHelper;

public class MessageInjector
implements Task,
ManagedLifecycle {
    private Log log = LogFactory.getLog(MessageInjector.class);
    private OMElement message = null;
    private String to = null;
    private String format = null;
    private String soapAction = null;
    private SynapseEnvironment synapseEnvironment;
    public static final String SOAP11_FORMAT = "soap11";
    public static final String SOAP12_FORMAT = "soap12";
    public static final String POX_FORMAT = "pox";
    public static final String GET_FORMAT = "get";
    private static final String INJECT_TO_PROXY = "proxy";
    private static final String INJECT_TO_SEQUENCE = "sequence";
    private static final String INJECT_TO_MAIN_SEQ = "main";
    private String injectTo = "main";
    private String sequenceName = null;
    private String proxyName = null;

    @Override
    public void init(SynapseEnvironment se) {
        this.synapseEnvironment = se;
    }

    public void setMessage(OMElement elem) {
        this.log.debug((Object)("set message " + elem.toString()));
        this.message = elem;
    }

    public void setTo(String url) {
        this.to = url;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public void setInjectTo(String injectTo) {
        this.injectTo = injectTo;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    public void execute() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"execute");
        }
        if (this.synapseEnvironment == null) {
            this.handleError("Synapse Environment not set");
            return;
        }
        if (this.message == null) {
            this.handleError("message not set");
            return;
        }
        if (INJECT_TO_PROXY.equalsIgnoreCase(this.injectTo)) {
            if (this.proxyName == null || this.proxyName.equals("")) {
                this.handleError("Proxy service name not specified");
            }
            org.apache.axis2.context.MessageContext axis2MsgCtx = new org.apache.axis2.context.MessageContext();
            ConfigurationContext configurationContext = ((Axis2SynapseEnvironment)this.synapseEnvironment).getAxis2ConfigurationContext();
            axis2MsgCtx.setConfigurationContext(configurationContext);
            axis2MsgCtx.setIncomingTransportName("local");
            axis2MsgCtx.setServerSide(true);
            axis2MsgCtx.setMessageID(UIDGenerator.generateURNString());
            try {
                AxisService axisService = configurationContext.getAxisConfiguration().getService(this.proxyName);
                if (axisService == null) {
                    this.handleError("Proxy Service: " + this.proxyName + " not found");
                }
                axis2MsgCtx.setAxisService(axisService);
            }
            catch (AxisFault axisFault) {
                this.handleError("Error occurred while attempting to find the Proxy Service");
            }
            if (this.to != null) {
                axis2MsgCtx.setTo(new EndpointReference(this.to));
            }
            SOAPEnvelope envelope = null;
            if (this.format == null) {
                envelope = OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope();
            } else if (SOAP11_FORMAT.equalsIgnoreCase(this.format)) {
                envelope = OMAbstractFactory.getSOAP11Factory().createSOAPEnvelope();
            } else if (SOAP12_FORMAT.equalsIgnoreCase(this.format)) {
                envelope = OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope();
            } else if (POX_FORMAT.equalsIgnoreCase(this.format)) {
                envelope = OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope();
                axis2MsgCtx.setDoingREST(true);
            } else if (GET_FORMAT.equalsIgnoreCase(this.format)) {
                envelope = OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope();
                axis2MsgCtx.setDoingREST(true);
                axis2MsgCtx.setProperty("HTTP_METHOD", (Object)"GET");
            } else {
                this.handleError("incorrect format specified");
            }
            try {
                PayloadHelper.setXMLPayload(envelope, this.message.cloneOMElement());
                axis2MsgCtx.setEnvelope(envelope);
            }
            catch (AxisFault axisFault) {
                this.handleError("Error in setting the message payload : " + this.message);
            }
            if (this.soapAction != null) {
                axis2MsgCtx.setSoapAction(this.soapAction);
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("injecting message to proxy service : " + this.proxyName));
                }
                AxisEngine.receive((org.apache.axis2.context.MessageContext)axis2MsgCtx);
            }
            catch (AxisFault axisFault) {
                this.handleError("Error occurred while invoking proxy service : " + this.proxyName);
            }
        } else {
            MessageContext mc = this.synapseEnvironment.createMessageContext();
            mc.setMessageID(UIDGenerator.generateURNString());
            mc.pushFaultHandler(new MediatorFaultHandler(mc.getFaultSequence()));
            if (this.to != null) {
                mc.setTo(new EndpointReference(this.to));
            }
            if (this.format == null) {
                PayloadHelper.setXMLPayload(mc, this.message.cloneOMElement());
            } else {
                try {
                    if (SOAP11_FORMAT.equalsIgnoreCase(this.format)) {
                        mc.setEnvelope(OMAbstractFactory.getSOAP11Factory().createSOAPEnvelope());
                    } else if (SOAP12_FORMAT.equalsIgnoreCase(this.format)) {
                        mc.setEnvelope(OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope());
                    } else if (POX_FORMAT.equalsIgnoreCase(this.format)) {
                        mc.setDoingPOX(true);
                    } else if (GET_FORMAT.equalsIgnoreCase(this.format)) {
                        mc.setDoingGET(true);
                    }
                    PayloadHelper.setXMLPayload(mc, this.message.cloneOMElement());
                }
                catch (AxisFault axisFault) {
                    this.handleError("Error in setting the message payload : " + this.message);
                }
            }
            if (this.soapAction != null) {
                mc.setSoapAction(this.soapAction);
            }
            if (INJECT_TO_SEQUENCE.equalsIgnoreCase(this.injectTo)) {
                SequenceMediator seq;
                if (this.sequenceName == null || this.sequenceName.equals("")) {
                    this.handleError("Sequence name not specified");
                }
                if ((seq = (SequenceMediator)this.synapseEnvironment.getSynapseConfiguration().getSequence(this.sequenceName)) != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("injecting message to sequence : " + this.sequenceName));
                    }
                    this.synapseEnvironment.injectAsync(mc, seq);
                } else {
                    this.handleError("Sequence: " + this.sequenceName + " not found");
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"injecting message to main sequence");
                }
                this.synapseEnvironment.injectMessage(mc);
            }
        }
    }

    @Override
    public void destroy() {
    }

    private void handleError(String msg) {
        this.log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

