/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.task;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;
import org.apache.synapse.task.SynapseTaskException;
import org.apache.synapse.task.TaskDescriptionRepository;
import org.apache.synapse.task.TaskDescriptionRepositoryFactory;
import org.apache.synapse.task.TaskScheduler;
import org.apache.synapse.task.TaskSchedulerFactory;

public class SynapseTaskManager {
    private static final Log log = LogFactory.getLog(SynapseTaskManager.class);
    private TaskDescriptionRepository taskDescriptionRepository;
    private TaskScheduler taskScheduler;
    private boolean initialized = false;

    public SynapseTaskManager() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Created the SynapseTaskManager singleton instance");
        }
    }

    public void init(TaskDescriptionRepository taskDescriptionRepository, TaskScheduler taskScheduler) {
        if (this.initialized) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Task manager already initialized. Skipping re-initialization.");
            }
            return;
        }
        if (taskDescriptionRepository != null) {
            this.taskDescriptionRepository = taskDescriptionRepository;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating new TaskDescriptionRepository as given instance is null.");
            }
            this.taskDescriptionRepository = TaskDescriptionRepositoryFactory.getTaskDescriptionRepository("task_description_repository");
        }
        if (taskScheduler != null) {
            this.taskScheduler = taskScheduler;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating new TaskScheduler as given instance is null.");
            }
            this.taskScheduler = TaskSchedulerFactory.getTaskScheduler("task_scheduler");
        }
        this.initialized = true;
    }

    public TaskDescriptionRepository getTaskDescriptionRepository() {
        this.assertInitialized();
        return this.taskDescriptionRepository;
    }

    public TaskScheduler getTaskScheduler() {
        this.assertInitialized();
        return this.taskScheduler;
    }

    private void assertInitialized() {
        if (!this.initialized) {
            String msg = "Task helper has not been initialized, it requires to be initialized";
            log.error((Object)msg);
            throw new SynapseCommonsException(msg);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void cleanup() {
        this.assertInitialized();
        log.info((Object)"Shutting down the task manager");
        this.taskScheduler.shutDown();
        this.initialized = false;
    }

    public void pauseAll() {
        if (this.taskScheduler != null && this.taskScheduler.isInitialized()) {
            try {
                this.taskScheduler.pauseAll();
            }
            catch (SynapseTaskException synapseTaskException) {
                // empty catch block
            }
        }
    }

    public void resumeAll() {
        if (this.taskScheduler != null) {
            try {
                this.taskScheduler.resumeAll();
            }
            catch (SynapseTaskException synapseTaskException) {
                // empty catch block
            }
        }
    }
}

