/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.util.StringUtils;

public class StaticListableBeanFactory
implements ListableBeanFactory {
    private final Map beans = new HashMap();
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public void addBean(String name, Object bean) {
        this.beans.put(name, bean);
    }

    public Object getBean(String name) throws BeansException {
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        Object bean = this.beans.get(beanName);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(beanName, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (BeanFactoryUtils.isFactoryDereference(name) && !(bean instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(beanName, bean.getClass());
        }
        if (bean instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name)) {
            try {
                return ((FactoryBean)bean).getObject();
            }
            catch (Exception ex) {
                throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
            }
        }
        return bean;
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        Object bean = this.getBean(name);
        if (requiredType != null && !requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean.getClass());
        }
        return bean;
    }

    public boolean containsBean(String name) {
        return this.beans.containsKey(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        Object bean = this.getBean(name);
        if (bean instanceof FactoryBean) {
            return ((FactoryBean)bean).isSingleton();
        }
        return true;
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        Object bean = this.beans.get(beanName);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(beanName, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (bean instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name)) {
            return ((FactoryBean)bean).getObjectType();
        }
        return bean.getClass();
    }

    public String[] getAliases(String name) {
        return new String[0];
    }

    public boolean containsBeanDefinition(String name) {
        return this.beans.containsKey(name);
    }

    public int getBeanDefinitionCount() {
        return this.beans.size();
    }

    public String[] getBeanDefinitionNames() {
        return StringUtils.toStringArray(this.beans.keySet());
    }

    public String[] getBeanDefinitionNames(Class type) {
        ArrayList<String> matches = new ArrayList<String>();
        Set keys = this.beans.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object beanInstance = this.beans.get(name);
            if (!type.isInstance(beanInstance)) continue;
            matches.add(name);
        }
        return StringUtils.toStringArray(matches);
    }

    public String[] getBeanNamesForType(Class type) {
        return this.getBeanNamesForType(type, true, true);
    }

    public String[] getBeanNamesForType(Class type, boolean includePrototypes, boolean includeFactoryBeans) {
        boolean isFactoryType = type != null && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = StaticListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(type);
        ArrayList<String> matches = new ArrayList<String>();
        Set keys = this.beans.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object beanInstance = this.beans.get(name);
            if (beanInstance instanceof FactoryBean && !isFactoryType) {
                Class objectType;
                if (!includeFactoryBeans || (objectType = ((FactoryBean)beanInstance).getObjectType()) == null || !type.isAssignableFrom(objectType)) continue;
                matches.add(name);
                continue;
            }
            if (!type.isInstance(beanInstance)) continue;
            matches.add(name);
        }
        return StringUtils.toStringArray(matches);
    }

    public Map getBeansOfType(Class type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        boolean isFactoryType = type != null && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = StaticListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(type);
        HashMap<String, Object> matches = new HashMap<String, Object>();
        Iterator it = this.beans.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String beanName = (String)entry.getKey();
            Object beanInstance = entry.getValue();
            if (beanInstance instanceof FactoryBean && !isFactoryType) {
                if (!includeFactoryBeans) continue;
                FactoryBean factory = (FactoryBean)beanInstance;
                Class objectType = factory.getObjectType();
                if (!includePrototypes && !factory.isSingleton() || objectType == null || !type.isAssignableFrom(objectType)) continue;
                matches.put(beanName, this.getBean(beanName));
                continue;
            }
            if (!type.isInstance(beanInstance)) continue;
            if (isFactoryType) {
                beanName = "&" + beanName;
            }
            matches.put(beanName, beanInstance);
        }
        return matches;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

