/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.format.syslog;

import java.io.IOException;
import java.io.InputStream;
import org.apache.synapse.format.syslog.ProtocolException;

public class InputStreamConsumer {
    private final InputStream in;
    private byte[] buffer = new byte[64];
    private int position;
    private int bufferPosition;
    private boolean endOfStream;

    public InputStreamConsumer(InputStream in) {
        this.in = in;
    }

    public int next() throws IOException {
        int c;
        if (this.position < this.bufferPosition) {
            return this.buffer[this.position];
        }
        if (this.endOfStream) {
            return -1;
        }
        if (this.bufferPosition == this.buffer.length) {
            byte[] newBuffer = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        if ((c = this.in.read(this.buffer, this.bufferPosition, this.buffer.length - this.bufferPosition)) == -1) {
            this.endOfStream = true;
            return -1;
        }
        this.bufferPosition += c;
        return this.buffer[this.position];
    }

    public void consume() {
        ++this.position;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void expect(int expected) throws IOException, ProtocolException {
        int next = this.next();
        if (next != expected) {
            throw new ProtocolException("Unexpected byte: expected " + expected + " ('" + (char)expected + "') , got " + next + " ('" + (char)next + "')");
        }
    }

    public void consume(int expected) throws IOException, ProtocolException {
        this.expect(expected);
        this.consume();
    }

    public int getInteger(int maxDigits) throws IOException, ProtocolException {
        int next;
        int digits = 0;
        int result = 0;
        while (48 <= (next = this.next()) && next <= 57) {
            if (++digits > maxDigits) {
                throw new ProtocolException("Numeric value too long");
            }
            this.consume();
            result = result * 10 + (next - 48);
        }
        if (digits == 0) {
            throw new ProtocolException("Expected numeric value");
        }
        return result;
    }
}

