/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixDatagen;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.util.UtilFunctions;

public class DataGenCPInstruction
extends UnaryCPInstruction {
    private Hop.DataGenMethod method = Hop.DataGenMethod.INVALID;
    private final CPOperand rows;
    private final CPOperand cols;
    private final int rowsInBlock;
    private final int colsInBlock;
    private final double minValue;
    private final double maxValue;
    private final double sparsity;
    private final String pdf;
    private final String pdfParams;
    private final long seed;
    private final CPOperand seq_from;
    private final CPOperand seq_to;
    private final CPOperand seq_incr;
    private final boolean replace;
    private final int numThreads;

    private DataGenCPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, int rpb, int cpb, double minValue, double maxValue, double sparsity, long seed, String probabilityDensityFunction, String pdfParams, int k, CPOperand seqFrom, CPOperand seqTo, CPOperand seqIncr, boolean replace, String opcode, String istr) {
        super(CPInstruction.CPType.Rand, op, in, out, opcode, istr);
        this.method = mthd;
        this.rows = rows;
        this.cols = cols;
        this.rowsInBlock = rpb;
        this.colsInBlock = cpb;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.sparsity = sparsity;
        this.seed = seed;
        this.pdf = probabilityDensityFunction;
        this.pdfParams = pdfParams;
        this.numThreads = k;
        this.seq_from = seqFrom;
        this.seq_to = seqTo;
        this.seq_incr = seqIncr;
        this.replace = replace;
    }

    private DataGenCPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, int rpb, int cpb, double minValue, double maxValue, double sparsity, long seed, String probabilityDensityFunction, String pdfParams, int k, String opcode, String istr) {
        this(op, mthd, in, out, rows, cols, rpb, cpb, minValue, maxValue, sparsity, seed, probabilityDensityFunction, pdfParams, k, null, null, null, false, opcode, istr);
    }

    private DataGenCPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, int rpb, int cpb, double maxValue, boolean replace, long seed, String opcode, String istr) {
        this(op, mthd, in, out, rows, cols, rpb, cpb, 0.0, maxValue, 1.0, seed, null, null, 1, null, null, null, replace, opcode, istr);
    }

    private DataGenCPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, int rpb, int cpb, CPOperand seqFrom, CPOperand seqTo, CPOperand seqIncr, String opcode, String istr) {
        this(op, mthd, in, out, rows, cols, rpb, cpb, 0.0, 1.0, 1.0, -1L, null, null, 1, seqFrom, seqTo, seqIncr, false, opcode, istr);
    }

    public long getRows() {
        return this.rows.isLiteral() ? Long.parseLong(this.rows.getName()) : -1L;
    }

    public long getCols() {
        return this.cols.isLiteral() ? Long.parseLong(this.cols.getName()) : -1L;
    }

    public int getRowsInBlock() {
        return this.rowsInBlock;
    }

    public int getColsInBlock() {
        return this.colsInBlock;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getSparsity() {
        return this.sparsity;
    }

    public static DataGenCPInstruction parseInstruction(String str) {
        Hop.DataGenMethod method = Hop.DataGenMethod.INVALID;
        String[] s = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = s[0];
        if (opcode.equalsIgnoreCase("rand")) {
            method = Hop.DataGenMethod.RAND;
            InstructionUtils.checkNumFields(s, 12);
        } else if (opcode.equalsIgnoreCase("seq")) {
            method = Hop.DataGenMethod.SEQ;
            InstructionUtils.checkNumFields(s, 8);
        } else if (opcode.equalsIgnoreCase("sample")) {
            method = Hop.DataGenMethod.SAMPLE;
            InstructionUtils.checkNumFields(s, 7);
        }
        CPOperand out = new CPOperand(s[s.length - 1]);
        Operator op = null;
        if (method == Hop.DataGenMethod.RAND) {
            CPOperand rows = new CPOperand(s[1]);
            CPOperand cols = new CPOperand(s[2]);
            int rpb = Integer.parseInt(s[3]);
            int cpb = Integer.parseInt(s[4]);
            double minValue = !s[5].contains("\u00b6") ? Double.valueOf(s[5]) : -1.0;
            double maxValue = !s[6].contains("\u00b6") ? Double.valueOf(s[6]) : -1.0;
            double sparsity = !s[7].contains("\u00b6") ? Double.valueOf(s[7]) : -1.0;
            long seed = !s[8].contains("\u00b6") ? Long.valueOf(s[8]) : -1L;
            String pdf = s[9];
            String pdfParams = !s[10].contains("\u00b6") ? s[10] : null;
            int k = Integer.parseInt(s[11]);
            return new DataGenCPInstruction(op, method, null, out, rows, cols, rpb, cpb, minValue, maxValue, sparsity, seed, pdf, pdfParams, k, opcode, str);
        }
        if (method == Hop.DataGenMethod.SEQ) {
            int rpb = Integer.parseInt(s[3]);
            int cpb = Integer.parseInt(s[4]);
            CPOperand from = new CPOperand(s[5]);
            CPOperand to = new CPOperand(s[6]);
            CPOperand incr = new CPOperand(s[7]);
            return new DataGenCPInstruction(op, method, null, out, null, null, rpb, cpb, from, to, incr, opcode, str);
        }
        if (method == Hop.DataGenMethod.SAMPLE) {
            double max = !s[1].contains("\u00b6") ? Double.valueOf(s[1]) : 0.0;
            CPOperand rows = new CPOperand(s[2]);
            CPOperand cols = new CPOperand("1", Expression.ValueType.INT, Expression.DataType.SCALAR);
            boolean replace = !s[3].contains("\u00b6") && Boolean.valueOf(s[3]) != false;
            long seed = Long.parseLong(s[4]);
            int rpb = Integer.parseInt(s[5]);
            int cpb = Integer.parseInt(s[6]);
            return new DataGenCPInstruction(op, method, null, out, rows, cols, rpb, cpb, max, replace, seed, opcode, str);
        }
        throw new DMLRuntimeException("Unrecognized data generation method: " + (Object)((Object)method));
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock soresBlock = null;
        if (this.method == Hop.DataGenMethod.RAND) {
            long lrows = ec.getScalarInput(this.rows).getLongValue();
            long lcols = ec.getScalarInput(this.cols).getLongValue();
            DataGenCPInstruction.checkValidDimensions(lrows, lcols);
            long lSeed = this.seed;
            if (lSeed == -1L) {
                lSeed = DataGenOp.generateRandomSeed();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Process DataGenCPInstruction rand with seed = " + lSeed + "."));
            }
            RandomMatrixGenerator rgen = LibMatrixDatagen.createRandomMatrixGenerator(this.pdf, (int)lrows, (int)lcols, this.rowsInBlock, this.colsInBlock, this.sparsity, this.minValue, this.maxValue, this.pdfParams);
            soresBlock = MatrixBlock.randOperations(rgen, this.seed, this.numThreads);
        } else if (this.method == Hop.DataGenMethod.SEQ) {
            double lfrom = ec.getScalarInput(this.seq_from).getDoubleValue();
            double lto = ec.getScalarInput(this.seq_to).getDoubleValue();
            double lincr = ec.getScalarInput(this.seq_incr).getDoubleValue();
            lincr = LibMatrixDatagen.updateSeqIncr(lfrom, lto, lincr);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Process DataGenCPInstruction seq with seqFrom=" + lfrom + ", seqTo=" + lto + ", seqIncr" + lincr));
            }
            soresBlock = MatrixBlock.seqOperations(lfrom, lto, lincr);
        } else if (this.method == Hop.DataGenMethod.SAMPLE) {
            long lrows = ec.getScalarInput(this.rows).getLongValue();
            long range = UtilFunctions.toLong(this.maxValue);
            DataGenCPInstruction.checkValidDimensions(lrows, 1L);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Process DataGenCPInstruction sample with range=" + range + ", size=" + lrows + ", replace" + this.replace + ", seed=" + this.seed));
            }
            if (range < lrows && !this.replace) {
                throw new DMLRuntimeException("Sample (size=" + lrows + ") larger than population (size=" + range + ") can only be generated with replacement.");
            }
            soresBlock = MatrixBlock.sampleOperations(range, (int)lrows, this.replace, this.seed);
        }
        if (soresBlock.getInMemorySize() < 0x800000L) {
            soresBlock.examSparsity();
        }
        ec.setMatrixOutput(this.output.getName(), soresBlock, this.getExtendedOpcode());
    }

    private static void checkValidDimensions(long rows, long cols) {
        if (rows > Integer.MAX_VALUE || cols > Integer.MAX_VALUE) {
            throw new DMLRuntimeException("DataGenCPInstruction does not support dimensions larger than integer: rows=" + rows + ", cols=" + cols + ".");
        }
    }
}

