/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.test.conv2d_simple.Backward_output;
import org.apache.sysml.scripts.nn.test.conv2d_simple.Forward_output;
import org.apache.sysml.scripts.nn.test.conv2d_simple.Init_output;

public class Conv2d_simple
extends Script {
    public Conv2d_simple() {
        String string = "scripts/nn/test/conv2d_simple.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Init_output init(Object object, Object object2, Object object3, Object object4) {
        String string = "source('scripts/nn/test/conv2d_simple.dml') as mlcontextns;[W, b] = mlcontextns::init(F, C, Hf, Wf);";
        Script script = new Script(string);
        script.in("F", object).in("C", object2).in("Hf", object3).in("Wf", object4).out("W").out("b");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("W");
        Matrix matrix2 = mLResults.getMatrix("b");
        Init_output init_output = new Init_output(matrix, matrix2);
        return init_output;
    }

    public String init__docs() {
        String string = "init = function(int F, int C, int Hf, int Wf)\n    return (matrix[double] W, matrix[double] b) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * We use the heuristic by He et al., which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * unit-Gaussian weights by a factor of sqrt(2/n), under the\n   * assumption of relu neurons.\n   *  - http://arxiv.org/abs/1502.01852\n   *\n   * Inputs:\n   *  - F: Number of filters.\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (F, C*Hf*Wf).\n   *  - b: Biases, of shape (F, 1).\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(int F, int C, int Hf, int Wf)\n    return (matrix[double] W, matrix[double] b) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * We use the heuristic by He et al., which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * unit-Gaussian weights by a factor of sqrt(2/n), under the\n   * assumption of relu neurons.\n   *  - http://arxiv.org/abs/1502.01852\n   *\n   * Inputs:\n   *  - F: Number of filters.\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (F, C*Hf*Wf).\n   *  - b: Biases, of shape (F, 1).\n   */\n  W = rand(rows=F, cols=C*Hf*Wf, pdf=\"normal\") * sqrt(2.0/(C*Hf*Wf))\n  b = matrix(0, rows=F, cols=1)\n}\n";
        return string;
    }

    public Forward_output forward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12) {
        String string = "source('scripts/nn/test/conv2d_simple.dml') as mlcontextns;[out, Hout, Wout] = mlcontextns::forward(X, W, b, C, Hin, Win, Hf, Wf, strideh, stridew, padh, padw);";
        Script script = new Script(string);
        script.in("X", object).in("W", object2).in("b", object3).in("C", object4).in("Hin", object5).in("Win", object6).in("Hf", object7).in("Wf", object8).in("strideh", object9).in("stridew", object10).in("padh", object11).in("padw", object12).out("out").out("Hout").out("Wout");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        long l = mLResults.getLong("Hout");
        long l2 = mLResults.getLong("Wout");
        Forward_output forward_output = new Forward_output(matrix, l, l2);
        return forward_output;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b,\n                   int C, int Hin, int Win, int Hf, int Wf,\n                   int strideh, int stridew, int padh, int padw)\n    return (matrix[double] out, int Hout, int Wout) {\n  /*\n   * Computes the forward pass for a 2D spatial convolutional layer with\n   * F filters.  The input data has N examples, each represented as a 3D\n   * volume unrolled into a single vector.\n   *\n   * This implementation is intended to be a simple, reference version.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (F, C*Hf*Wf).\n   *  - b: Biases, of shape (F, 1).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, F*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b,\n                   int C, int Hin, int Win, int Hf, int Wf,\n                   int strideh, int stridew, int padh, int padw)\n    return (matrix[double] out, int Hout, int Wout) {\n  /*\n   * Computes the forward pass for a 2D spatial convolutional layer with\n   * F filters.  The input data has N examples, each represented as a 3D\n   * volume unrolled into a single vector.\n   *\n   * This implementation is intended to be a simple, reference version.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (F, C*Hf*Wf).\n   *  - b: Biases, of shape (F, 1).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, F*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   */\n  N = nrow(X)\n  F = nrow(W)\n  Hout = as.integer(floor((Hin + 2*padh - Hf)/strideh + 1))\n  Wout = as.integer(floor((Win + 2*padw - Wf)/stridew + 1))\n\n  # Create output volume\n  out = matrix(0, rows=N, cols=F*Hout*Wout)\n\n  # Convolution - Simple reference implementation\n  parfor (n in 1:N) {  # all examples\n    Xn = matrix(X[n,], rows=C, cols=Hin*Win)\n    # Pad image\n    Xn_padded = matrix(0, rows=C, cols=(Hin+2*padh)*(Win+2*padw))  # zeros\n    parfor (c in 1:C) {\n      Xn_slice = matrix(Xn[c,], rows=Hin, cols=Win)  # depth slice C reshaped\n      Xn_padded_slice = matrix(Xn_padded[c,], rows=Hin+2*padh, cols=Win+2*padw)\n      Xn_padded_slice[padh+1:padh+Hin, padw+1:padw+Win] = Xn_slice\n      Xn_padded[c,] = matrix(Xn_padded_slice, rows=1, cols=(Hin+2*padh)*(Win+2*padw))  # reshape\n    }\n    # Convolve image with filters\n    parfor (f in 1:F, check=0) {  # all filters\n      parfor (hout in 1:Hout, check=0) {  # all output rows\n        h0 = (hout-1)*strideh + 1\n        parfor (wout in 1:Wout, check=0) {  # all output columns\n          w0 = (wout-1)*stridew + 1\n          # Create a patch of the input example corresponding spatially to the filter sizes\n          Xn_padded_patch = matrix(0, rows=C, cols=Hf*Wf)  # zeros\n          parfor (c in 1:C, check=0) {\n            Xn_padded_slice = matrix(Xn_padded[c,], rows=Hin+2*padh, cols=Win+2*padw)  # reshape\n            Xn_padded_patch[c,] = matrix(Xn_padded_slice[h0:h0-1+Hf, w0:w0-1+Wf], rows=1,\n                                         cols=Hf*Wf)  # reshape\n          }\n          out[n, (f-1)*Hout*Wout + (hout-1)*Wout + wout] =\n              W[f,] %*% matrix(Xn_padded_patch, rows=C*Hf*Wf, cols=1) + b[f,]\n        }\n      }\n    }\n  }\n}\n";
        return string;
    }

    public Backward_output backward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15) {
        String string = "source('scripts/nn/test/conv2d_simple.dml') as mlcontextns;[dX, dW, db] = mlcontextns::backward(dout, Hout, Wout, X, W, b, C, Hin, Win, Hf, Wf, strideh, stridew, padh, padw);";
        Script script = new Script(string);
        script.in("dout", object).in("Hout", object2).in("Wout", object3).in("X", object4).in("W", object5).in("b", object6).in("C", object7).in("Hin", object8).in("Win", object9).in("Hf", object10).in("Wf", object11).in("strideh", object12).in("stridew", object13).in("padh", object14).in("padw", object15).out("dX").out("dW").out("db");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        Matrix matrix2 = mLResults.getMatrix("dW");
        Matrix matrix3 = mLResults.getMatrix("db");
        Backward_output backward_output = new Backward_output(matrix, matrix2, matrix3);
        return backward_output;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, int Hout, int Wout,\n                    matrix[double] X, matrix[double] W, matrix[double] b,\n                    int C, int Hin, int Win, int Hf, int Wf,\n                    int strideh, int stridew, int padh, int padw)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db) {\n  /*\n   * Computes the backward pass for a 2D spatial convolutional layer\n   * with F filters.\n   *\n   * This implementation is intended to be a simple, reference version.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of\n   *      shape (N, F*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (F, C*Hf*Wf).\n   *  - b: Biases, of shape (F, 1).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   *  - dW: Gradient wrt `W`, of shape (F, C*Hf*Wf).\n   *  - db: Gradient wrt `b`, of shape (F, 1).\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, int Hout, int Wout,\n                    matrix[double] X, matrix[double] W, matrix[double] b,\n                    int C, int Hin, int Win, int Hf, int Wf,\n                    int strideh, int stridew, int padh, int padw)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db) {\n  /*\n   * Computes the backward pass for a 2D spatial convolutional layer\n   * with F filters.\n   *\n   * This implementation is intended to be a simple, reference version.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of\n   *      shape (N, F*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (F, C*Hf*Wf).\n   *  - b: Biases, of shape (F, 1).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   *  - dW: Gradient wrt `W`, of shape (F, C*Hf*Wf).\n   *  - db: Gradient wrt `b`, of shape (F, 1).\n   */\n  N = nrow(X)\n  F = nrow(W)\n\n  # Create gradient volumes\n  dX = matrix(0, rows=N, cols=C*Hin*Win)\n  dW = matrix(0, rows=F, cols=C*Hf*Wf)\n  db = matrix(0, rows=F, cols=1)\n\n  # Partial derivatives for convolution - Simple reference implementation\n  for (n in 1:N) {  # all examples\n    Xn = matrix(X[n,], rows=C, cols=Hin*Win)\n    # Pad image\n    Xn_padded = matrix(0, rows=C, cols=(Hin+2*padh)*(Win+2*padw))  # zeros\n    parfor (c in 1:C) {\n      Xn_slice = matrix(Xn[c,], rows=Hin, cols=Win)  # depth slice C reshaped\n      Xn_padded_slice = matrix(Xn_padded[c,], rows=Hin+2*padh, cols=Win+2*padw)\n      Xn_padded_slice[padh+1:padh+Hin, padw+1:padw+Win] = Xn_slice\n      Xn_padded[c,] = matrix(Xn_padded_slice, rows=1, cols=(Hin+2*padh)*(Win+2*padw))  # reshape\n    }\n    dXn_padded = matrix(0, rows=C, cols=(Hin+2*padh)*(Win+2*padw))\n    for (f in 1:F) {  # all filters\n      for (hout in 1:Hout) {  # all output rows\n        h0 = (hout-1) * strideh + 1\n        for (wout in 1:Wout) {  # all output columns\n          w0 = (wout-1) * stridew + 1\n          # Create a patch of the input example corresponding spatially to the filter sizes\n          Xn_padded_patch = matrix(0, rows=C, cols=Hf*Wf)  # zeros\n          dXn_padded_patch = matrix(W[f,] * dout[n, (f-1)*Hout*Wout + (hout-1)*Wout + wout],\n                                    rows=C, cols=Hf*Wf)  # reshape\n          for (c in 1:C) {\n            Xn_padded_slice = matrix(Xn_padded[c,], rows=Hin+2*padh, cols=Win+2*padw)  # reshape\n            Xn_padded_patch[c,] = matrix(Xn_padded_slice[h0:h0-1+Hf, w0:w0-1+Wf],\n                                         rows=1, cols=Hf*Wf)  # reshape\n            dXn_padded_slice = matrix(0, rows=Hin+2*padh, cols=Win+2*padw)\n            dXn_padded_slice[h0:h0-1+Hf, w0:w0-1+Wf] = matrix(dXn_padded_patch[c,],\n                                                              rows=Hf, cols=Wf)  # reshape\n            dXn_padded[c,] = dXn_padded[c,] + matrix(dXn_padded_slice,\n                                                     rows=1, cols=(Hin+2*padh)*(Win+2*padw))\n          }\n          dW[f,] = dW[f,]\n                   + matrix(Xn_padded_patch, rows=1, cols=C*Hf*Wf)\n                   * dout[n, (f-1)*Hout*Wout + (hout-1)*Wout + wout]\n          db[f,] = db[f,] + dout[n, (f-1)*Hout*Wout + (hout-1)*Wout + wout]\n        }\n      }\n    }\n    # Unpad derivs on input\n    dXn = matrix(0, rows=C, cols=Hin*Win)\n    parfor (c in 1:C, check=0) {\n      dXn_padded_slice = matrix(dXn_padded[c,], rows=(Hin+2*padh), cols=(Win+2*padw))\n      dXn_slice = dXn_padded_slice[padh+1:padh+Hin, padw+1:padw+Win]\n      dXn[c,] = matrix(dXn_slice, rows=1, cols=Hin*Win)\n    }\n    dX[n,] = matrix(dXn, rows=1, cols=C*Hin*Win)\n  }\n}\n";
        return string;
    }
}

