/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class PMMJCPInstruction
extends ComputationCPInstruction {
    private final int _numThreads;

    private PMMJCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, int k, String opcode, String istr) {
        super(CPInstruction.CPType.AggregateBinary, op, in1, in2, in3, out, opcode, istr);
        this._numThreads = k;
    }

    public static PMMJCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 5);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[4]);
        int k = Integer.parseInt(parts[5]);
        if (!opcode.equalsIgnoreCase("pmm")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an PMMJCPInstruction: " + str);
        }
        return new PMMJCPInstruction(new Operator(true), in1, in2, in3, out, k, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock matBlock1 = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        MatrixBlock matBlock2 = ec.getMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        int rlen = (int)ec.getScalarInput(this.input3.getName(), this.input3.getValueType(), this.input3.isLiteral()).getLongValue();
        MatrixBlock ret = new MatrixBlock(rlen, matBlock2.getNumColumns(), matBlock2.isInSparseFormat());
        matBlock1.permutationMatrixMultOperations(matBlock2, ret, null, this._numThreads);
        ec.setMatrixOutput(this.output.getName(), ret, this.getExtendedOpcode());
        ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        ec.releaseMatrixInput(this.input2.getName(), this.getExtendedOpcode());
    }
}

