/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.layers.conv2d_transpose_depthwise.Backward_output;
import org.apache.sysml.scripts.nn.layers.conv2d_transpose_depthwise.Forward_output;
import org.apache.sysml.scripts.nn.layers.conv2d_transpose_depthwise.Init_output;

public class Conv2d_transpose_depthwise
extends Script {
    public Conv2d_transpose_depthwise() {
        String string = "scripts/nn/layers/conv2d_transpose_depthwise.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Init_output init(Object object, Object object2, Object object3, Object object4) {
        String string = "source('scripts/nn/layers/conv2d_transpose_depthwise.dml') as mlcontextns;[W, b] = mlcontextns::init(C, M, Hf, Wf);";
        Script script = new Script(string);
        script.in("C", object).in("M", object2).in("Hf", object3).in("Wf", object4).out("W").out("b");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("W");
        Matrix matrix2 = mLResults.getMatrix("b");
        Init_output init_output = new Init_output(matrix, matrix2);
        return init_output;
    }

    public String init__docs() {
        String string = "init = function(int C, int M, int Hf, int Wf)\n    return (matrix[double] W, matrix[double] b){\n  /*\n   * Utility function to initialize the parameters of this layer.\n   *\n   * We use the heuristic by He et al., which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * unit-Gaussian weights by a factor of sqrt(2/n), under the\n   * assumption of relu neurons.\n   *  - http://arxiv.org/abs/1502.01852\n   *\n   * Inputs:\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - M: Depth of each filter (C must be divisible by M).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (C/M, M*Hf*Wf).\n   *  - b: Biases, of shape (C/M, 1).\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(int C, int M, int Hf, int Wf)\n    return (matrix[double] W, matrix[double] b){\n  /*\n   * Utility function to initialize the parameters of this layer.\n   *\n   * We use the heuristic by He et al., which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * unit-Gaussian weights by a factor of sqrt(2/n), under the\n   * assumption of relu neurons.\n   *  - http://arxiv.org/abs/1502.01852\n   *\n   * Inputs:\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - M: Depth of each filter (C must be divisible by M).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (C/M, M*Hf*Wf).\n   *  - b: Biases, of shape (C/M, 1).\n   */\n  W = rand(rows=C/M, cols=M*Hf*Wf, pdf=\"normal\") * sqrt(2/(M*Hf*Wf))\n  b = matrix(0, rows=C/M, cols=1)\n}\n";
        return string;
    }

    public Forward_output forward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15) {
        String string = "source('scripts/nn/layers/conv2d_transpose_depthwise.dml') as mlcontextns;[out, Hout, Wout] = mlcontextns::forward(X, W, b, C, Hin, Win, M, Hf, Wf, strideh, stridew, padh, padw, out_padh, out_padw);";
        Script script = new Script(string);
        script.in("X", object).in("W", object2).in("b", object3).in("C", object4).in("Hin", object5).in("Win", object6).in("M", object7).in("Hf", object8).in("Wf", object9).in("strideh", object10).in("stridew", object11).in("padh", object12).in("padw", object13).in("out_padh", object14).in("out_padw", object15).out("out").out("Hout").out("Wout");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        long l = mLResults.getLong("Hout");
        long l2 = mLResults.getLong("Wout");
        Forward_output forward_output = new Forward_output(matrix, l, l2);
        return forward_output;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b,\n                   int C, int Hin, int Win, int M, int Hf, int Wf,\n                   int strideh, int stridew, int padh, int padw,\n                   int out_padh, int out_padw)\n    return (matrix[double] out, int Hout, int Wout){\n  /*\n   * Computes the forward pass for a 2D depthwise spatial transpose\n   * convolutional layer with C/M filters of depth M.  The input data\n   * has N examples, each represented as a 3D volume with C channels\n   * unrolled into a single vector.  For each group of M input channels,\n   * a 2D transpose convolution is applied with 1 unique filter,\n   * yielding 1 output channel per input group of M input channels.\n   * The resulting C/M separate output channels are then concatenated\n   * together channel-wise into a single volume of C/M output channels.\n   *\n   * For clarity, if we were to use the same terminology as a regular\n   * depthwise convolution, a depthwise transpose convolution has the\n   * ability to contract each group of M input channels (from a total of\n   * C*M input channels) back to a single output channel, thus leading\n   * to C output channels.  Thus, this is the \"transpose\" of the regular\n   * depthwise convolution.  To keep the convention of always referring\n   * to the number of input channels as C, in this depthwise transpose\n   * layer we can reformulate the above by dividing by M.  With this\n   * reformulation, we can now state that there are C input channels,\n   * and for each group of M inputs we output a single output channel,\n   * for a total of C/M output channels.  For this, we use 1 filter of\n   * depth M for each group of M input channels, and we store W as\n   * `(C/M, M*Hf*Wf)`.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (C/M, M*Hf*Wf).\n   *  - b: Biases, of shape (C/M, 1).\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - M: Depth of each filter (C must be divisible by M).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *  - out_padh: extra padding for top side. This should\n   *      lie in [0, strideh-1].\n   *  - out_padw: extra padding for right side. This should\n   *      lie in [0, stridew-1].\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C/M*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b,\n                   int C, int Hin, int Win, int M, int Hf, int Wf,\n                   int strideh, int stridew, int padh, int padw,\n                   int out_padh, int out_padw)\n    return (matrix[double] out, int Hout, int Wout){\n  /*\n   * Computes the forward pass for a 2D depthwise spatial transpose\n   * convolutional layer with C/M filters of depth M.  The input data\n   * has N examples, each represented as a 3D volume with C channels\n   * unrolled into a single vector.  For each group of M input channels,\n   * a 2D transpose convolution is applied with 1 unique filter,\n   * yielding 1 output channel per input group of M input channels.\n   * The resulting C/M separate output channels are then concatenated\n   * together channel-wise into a single volume of C/M output channels.\n   *\n   * For clarity, if we were to use the same terminology as a regular\n   * depthwise convolution, a depthwise transpose convolution has the\n   * ability to contract each group of M input channels (from a total of\n   * C*M input channels) back to a single output channel, thus leading\n   * to C output channels.  Thus, this is the \"transpose\" of the regular\n   * depthwise convolution.  To keep the convention of always referring\n   * to the number of input channels as C, in this depthwise transpose\n   * layer we can reformulate the above by dividing by M.  With this\n   * reformulation, we can now state that there are C input channels,\n   * and for each group of M inputs we output a single output channel,\n   * for a total of C/M output channels.  For this, we use 1 filter of\n   * depth M for each group of M input channels, and we store W as\n   * `(C/M, M*Hf*Wf)`.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (C/M, M*Hf*Wf).\n   *  - b: Biases, of shape (C/M, 1).\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - M: Depth of each filter (C must be divisible by M).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *  - out_padh: extra padding for top side. This should\n   *      lie in [0, strideh-1].\n   *  - out_padw: extra padding for right side. This should\n   *      lie in [0, stridew-1].\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C/M*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   */\n  N = nrow(X)\n  F = nrow(W)\n  Hout = strideh*(Hin-1) - 2*padh + Hf + out_padh\n  Wout = stridew*(Win-1) - 2*padw + Wf + out_padw\n\n  # create output volume\n  # NOTE: We initialize to 1s vs. 0s to avoid conversions between sparse and dense formats. \n  # This is a complete hack until the engine is improved.\n  out = matrix(1, rows=N, cols=C/M*Hout*Wout)\n\n  # depthwise transpose convolution\n  # TODO: Explore usage of parfor loops more to determine if they can provide a performance\n  # benefit.  Initial tests show that they are slower than the regular for loop, likely because\n  # they cause a reduction from a multithreaded conv2d op to a singlethreaded version.  For a\n  # number of filters C/M >> the number of examples, it's possible that the parfor loop could be\n  # faster.\n  #parfor (f in 1:F, check=0) {  # each channel\n  for (f in 1:F) {\n    # compute gradient wrt data of conv2d using 1 filter and M input channels\n    w = matrix(W[f,], rows=M, cols=Hf*Wf)  # 1 filter, of shape (M, 1*Hf*Wf)\n    Xm = X[,((f-1)*M*Hin*Win + 1):f*M*Hin*Win]  # M input channels, of shape (N, M*Hin*Win)\n    outm = conv2d_backward_data(w, Xm, stride=[strideh,stridew], padding=[padh,padw],\n                                input_shape=[N,1,Hout,Wout], filter_shape=[M,1,Hf,Wf])\n\n    # store\n    out[,((f-1)*Hout*Wout + 1):f*Hout*Wout] = outm  # outm has shape (N, 1*Hout*Wout)\n  }\n\n  # add bias term to each output filter\n  out = bias_add(out, b)\n}\n";
        return string;
    }

    public Backward_output backward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15, Object object16) {
        String string = "source('scripts/nn/layers/conv2d_transpose_depthwise.dml') as mlcontextns;[dX, dW, db] = mlcontextns::backward(dout, Hout, Wout, X, W, b, C, Hin, Win, M, Hf, Wf, strideh, stridew, padh, padw);";
        Script script = new Script(string);
        script.in("dout", object).in("Hout", object2).in("Wout", object3).in("X", object4).in("W", object5).in("b", object6).in("C", object7).in("Hin", object8).in("Win", object9).in("M", object10).in("Hf", object11).in("Wf", object12).in("strideh", object13).in("stridew", object14).in("padh", object15).in("padw", object16).out("dX").out("dW").out("db");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        Matrix matrix2 = mLResults.getMatrix("dW");
        Matrix matrix3 = mLResults.getMatrix("db");
        Backward_output backward_output = new Backward_output(matrix, matrix2, matrix3);
        return backward_output;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, int Hout, int Wout,\n                    matrix[double] X, matrix[double] W, matrix[double] b,\n                    int C, int Hin, int Win, int M, int Hf, int Wf,\n                    int strideh, int stridew, int padh, int padw)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db){\n  /*\n   * Computes the backward pass for a 2D spatial transpose\n   * convolutional layer with F filters.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of\n   *      shape (N, C/M*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (C/M, M*Hf*Wf).\n   *  - b: Biases, of shape (C/M, 1).\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - M: Depth of each filter (C must be divisible by M).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   *  - dW: Gradient wrt `W`, of shape (C/M, M*Hf*Wf).\n   *  - db: Gradient wrt `b`, of shape (C/M, 1).\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, int Hout, int Wout,\n                    matrix[double] X, matrix[double] W, matrix[double] b,\n                    int C, int Hin, int Win, int M, int Hf, int Wf,\n                    int strideh, int stridew, int padh, int padw)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db){\n  /*\n   * Computes the backward pass for a 2D spatial transpose\n   * convolutional layer with F filters.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of\n   *      shape (N, C/M*Hout*Wout).\n   *  - Hout: Output height.\n   *  - Wout: Output width.\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - W: Weights, of shape (C/M, M*Hf*Wf).\n   *  - b: Biases, of shape (C/M, 1).\n   *  - C: Number of input channels (dimensionality of depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - M: Depth of each filter (C must be divisible by M).\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   *  - dW: Gradient wrt `W`, of shape (C/M, M*Hf*Wf).\n   *  - db: Gradient wrt `b`, of shape (C/M, 1).\n   */\n  N = nrow(X)\n  F = nrow(W)\n\n  # create gradient volumes\n  # NOTE: We initialize to 1s vs. 0s to avoid conversions between sparse and dense formats. \n  # This is a complete hack until the engine is improved.\n  dX = matrix(1, rows=N, cols=C*Hin*Win)\n  dW = matrix(1, rows=C/M, cols=M*Hf*Wf)\n  db = matrix(1, rows=C/M, cols=1)\n\n  # depthwise transpose convolution\n  for (f in 1:F) {\n    # extract 1 gradient channel, 1 depth-1 filter, and M input channels, since the forward pass\n    # maps M input channels to 1 output channel for each filter\n    doutf = dout[,((f-1)*Hout*Wout + 1):f*Hout*Wout]  # shape (N, 1*Hout*Wout)\n    w = matrix(W[f,], rows=M, cols=Hf*Wf)  # 1 filter, of shape (M, 1*Hf*Wf)\n    Xm = X[,((f-1)*M*Hin*Win + 1):f*M*Hin*Win]  # M input channels, of shape (N, M*Hin*Win)\n\n    # compute gradients:\n    # conv2d_backward_filter takes the input and gradient wrt the output\n    # as first and second args, respectively. Given that we need to\n    # compute the grad wrt to filter for transpose convolution, where\n    # the roles of the input and output are reversed, we reverse the\n    # order of the args (along with setting input_shape to the dout\n    # shape).\n    dw = conv2d_backward_filter(doutf, Xm, stride=[strideh,stridew], padding=[padh,padw],\n                                input_shape=[N,1,Hout,Wout], filter_shape=[M,1,Hf,Wf])\n    # Since the forward for transpose convolution makes a call to\n    # conv2d_backward_data, to compute its derivative wrt to data\n    # we can run conv2d by applying the filter on the grad wrt the\n    # output (this makes sense because convolution transpose is the\n    # 'reverse' of convolution). It's easy to see that this will produce\n    # an output of the required size.\n    dXm = conv2d(doutf, w, input_shape=[N,1,Hout,Wout], filter_shape=[M,1,Hf,Wf],\n                 stride=[strideh,stridew], padding=[padh,padw])\n\n    # store\n    dX[,((f-1)*M*Hin*Win + 1):f*M*Hin*Win] = dXm\n    dW[f,] = matrix(dw, rows=1, cols=M*Hf*Wf)\n  }\n\n  # partial derivatives for bias vector\n  db = util::channel_sums(dout, C/M, Hout, Wout)\n}\n";
        return string;
    }
}

