/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.estim;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.estim.MMNode;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public abstract class SparsityEstimator {
    protected static final Log LOG = LogFactory.getLog((String)SparsityEstimator.class.getName());
    public static boolean MULTI_THREADED_BUILD = false;
    public static boolean MULTI_THREADED_ESTIM = false;
    public static final int MIN_PAR_THRESHOLD = 10240;
    private static OpCode[] EXACT_META_DATA_OPS = new OpCode[]{OpCode.EQZERO, OpCode.NEQZERO, OpCode.CBIND, OpCode.RBIND, OpCode.TRANS, OpCode.DIAG, OpCode.RESHAPE};

    public abstract MatrixCharacteristics estim(MMNode var1);

    public abstract double estim(MatrixBlock var1, MatrixBlock var2);

    public abstract double estim(MatrixBlock var1, MatrixBlock var2, OpCode var3);

    public abstract double estim(MatrixBlock var1, OpCode var2);

    protected boolean isExactMetadataOp(OpCode op) {
        return ArrayUtils.contains((Object[])EXACT_META_DATA_OPS, (Object)((Object)op));
    }

    protected MatrixCharacteristics estimExactMetaData(MatrixCharacteristics mc1, MatrixCharacteristics mc2, OpCode op) {
        switch (op) {
            case EQZERO: {
                return new MatrixCharacteristics(mc1.getRows(), mc1.getCols(), mc1.getRows() * mc1.getCols() - mc1.getNonZeros());
            }
            case DIAG: {
                return mc1.getCols() == 1L ? new MatrixCharacteristics(mc1.getRows(), mc1.getRows(), mc1.getNonZeros()) : new MatrixCharacteristics(mc1.getRows(), 1L, Math.min(mc1.getRows(), mc1.getNonZeros()));
            }
            case CBIND: {
                return new MatrixCharacteristics(mc1.getRows(), mc1.getCols() + mc2.getCols(), mc1.getNonZeros() + mc2.getNonZeros());
            }
            case RBIND: {
                return new MatrixCharacteristics(mc1.getRows() + mc2.getRows(), mc1.getCols(), mc1.getNonZeros() + mc2.getNonZeros());
            }
            case NEQZERO: 
            case TRANS: 
            case RESHAPE: {
                return mc1;
            }
        }
        throw new HopsException("Opcode is not an exact meta data operation: " + op.name());
    }

    public static enum OpCode {
        MM,
        MULT,
        PLUS,
        EQZERO,
        NEQZERO,
        CBIND,
        RBIND,
        TRANS,
        DIAG,
        RESHAPE;

    }
}

