/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.LocalJobRunner;
import org.apache.hadoop.mapred.LocalJobRunnerMetrics;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.LogParams;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LocalJobRunner
implements ClientProtocol {
    public static final Log LOG = LogFactory.getLog(LocalJobRunner.class);
    public static final String LOCAL_MAX_MAPS = "mapreduce.local.map.tasks.maximum";
    public static final String LOCAL_MAX_REDUCES = "mapreduce.local.reduce.tasks.maximum";
    private FileSystem fs;
    private HashMap<JobID, Job> jobs = new HashMap();
    private JobConf conf;
    private AtomicInteger map_tasks = new AtomicInteger(0);
    private AtomicInteger reduce_tasks = new AtomicInteger(0);
    final Random rand = new Random();
    private LocalJobRunnerMetrics myMetrics = null;
    private static final String jobDir = "localRunner/";
    private static int jobid = 0;
    private int randid;
    static final String TASK_CLEANUP_SUFFIX = ".cleanup";
    static final String JOBCACHE = "jobcache";

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) {
        return 37L;
    }

    @Override
    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
    }

    public LocalJobRunner(Configuration conf) throws IOException {
        this(new JobConf(conf));
    }

    @Deprecated
    public LocalJobRunner(JobConf conf) throws IOException {
        this.fs = FileSystem.getLocal(conf);
        this.conf = conf;
        this.myMetrics = new LocalJobRunnerMetrics(new JobConf(conf));
    }

    @Override
    public synchronized org.apache.hadoop.mapreduce.JobID getNewJobID() {
        return new org.apache.hadoop.mapreduce.JobID("local" + this.randid, ++jobid);
    }

    @Override
    public JobStatus submitJob(org.apache.hadoop.mapreduce.JobID jobid, String jobSubmitDir, Credentials credentials) throws IOException {
        Job job = new Job(this, JobID.downgrade((org.apache.hadoop.mapreduce.JobID)jobid), jobSubmitDir);
        Job.access$100((Job)job).setCredentials(credentials);
        return Job.access$1000((Job)job);
    }

    @Override
    public void killJob(org.apache.hadoop.mapreduce.JobID id) {
        this.jobs.get((Object)JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id)).killed = true;
        this.jobs.get(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id)).interrupt();
    }

    @Override
    public void setJobPriority(org.apache.hadoop.mapreduce.JobID id, String jp) throws IOException {
        throw new UnsupportedOperationException("Changing job priority in LocalJobRunner is not supported.");
    }

    @Override
    public boolean killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException {
        throw new UnsupportedOperationException("Killing tasks in LocalJobRunner is not supported");
    }

    @Override
    public TaskReport[] getTaskReports(org.apache.hadoop.mapreduce.JobID id, TaskType type) {
        return new TaskReport[0];
    }

    @Override
    public JobStatus getJobStatus(org.apache.hadoop.mapreduce.JobID id) {
        Job job = this.jobs.get(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id));
        if (job != null) {
            return Job.access$1000((Job)job);
        }
        return null;
    }

    @Override
    public Counters getJobCounters(org.apache.hadoop.mapreduce.JobID id) {
        Job job = this.jobs.get(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id));
        return new Counters((AbstractCounters)job.getCurrentCounters());
    }

    @Override
    public String getFilesystemName() throws IOException {
        return this.fs.getUri().toString();
    }

    @Override
    public ClusterMetrics getClusterMetrics() {
        int numMapTasks = this.map_tasks.get();
        int numReduceTasks = this.reduce_tasks.get();
        return new ClusterMetrics(numMapTasks, numReduceTasks, numMapTasks, numReduceTasks, 0, 0, 1, 1, this.jobs.size(), 1, 0, 0);
    }

    @Override
    public Cluster.JobTrackerStatus getJobTrackerStatus() {
        return Cluster.JobTrackerStatus.RUNNING;
    }

    @Override
    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return 0L;
    }

    @Override
    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        return new TaskTrackerInfo[0];
    }

    @Override
    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        return new TaskTrackerInfo[0];
    }

    @Override
    public TaskCompletionEvent[] getTaskCompletionEvents(org.apache.hadoop.mapreduce.JobID jobid, int fromEventId, int maxEvents) throws IOException {
        return TaskCompletionEvent.EMPTY_ARRAY;
    }

    @Override
    public JobStatus[] getAllJobs() {
        return null;
    }

    @Override
    public String[] getTaskDiagnostics(TaskAttemptID taskid) throws IOException {
        return new String[0];
    }

    @Override
    public String getSystemDir() {
        Path sysDir = new Path(this.conf.get("mapreduce.jobtracker.system.dir", "/tmp/hadoop/mapred/system"));
        return this.fs.makeQualified(sysDir).toString();
    }

    @Override
    public AccessControlList getQueueAdmins(String queueName) throws IOException {
        return new AccessControlList(" ");
    }

    @Override
    public String getStagingAreaDir() throws IOException {
        Path stagingRootDir = new Path(this.conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.randid = this.rand.nextInt(Integer.MAX_VALUE);
        String user = ugi != null ? ugi.getShortUserName() + this.randid : "dummy" + this.randid;
        return this.fs.makeQualified(new Path(stagingRootDir, user + "/.staging")).toString();
    }

    @Override
    public String getJobHistoryDir() {
        return null;
    }

    @Override
    public QueueInfo[] getChildQueues(String queueName) throws IOException {
        return null;
    }

    @Override
    public QueueInfo[] getRootQueues() throws IOException {
        return null;
    }

    @Override
    public QueueInfo[] getQueues() throws IOException {
        return null;
    }

    @Override
    public QueueInfo getQueue(String queue) throws IOException {
        return null;
    }

    @Override
    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        return null;
    }

    public static void setLocalMaxRunningMaps(JobContext job, int maxMaps) {
        job.getConfiguration().setInt("mapreduce.local.map.tasks.maximum", maxMaps);
    }

    public static int getLocalMaxRunningMaps(JobContext job) {
        return job.getConfiguration().getInt("mapreduce.local.map.tasks.maximum", 1);
    }

    public static void setLocalMaxRunningReduces(JobContext job, int maxReduces) {
        job.getConfiguration().setInt("mapreduce.local.reduce.tasks.maximum", maxReduces);
    }

    public static int getLocalMaxRunningReduces(JobContext job) {
        return job.getConfiguration().getInt("mapreduce.local.reduce.tasks.maximum", 1);
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        return null;
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        return 0L;
    }

    @Override
    public LogParams getLogFileParams(org.apache.hadoop.mapreduce.JobID jobID, TaskAttemptID taskAttemptID) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("Not supported");
    }

    static void setupChildMapredLocalDirs(Task t, JobConf conf) {
        String[] localDirs = conf.getTrimmedStrings("mapreduce.cluster.local.dir");
        String jobId = t.getJobID().toString();
        String taskId = t.getTaskID().toString();
        boolean isCleanup = t.isTaskCleanupTask();
        String user = t.getUser();
        StringBuffer childMapredLocalDir = new StringBuffer(localDirs[0] + "/" + LocalJobRunner.getLocalTaskDir(user, jobId, taskId, isCleanup));
        for (int i = 1; i < localDirs.length; ++i) {
            childMapredLocalDir.append("," + localDirs[i] + "/" + LocalJobRunner.getLocalTaskDir(user, jobId, taskId, isCleanup));
        }
        LOG.debug("mapreduce.cluster.local.dir for child : " + childMapredLocalDir);
        conf.set("mapreduce.cluster.local.dir", childMapredLocalDir.toString());
    }

    static String getLocalTaskDir(String user, String jobid, String taskid, boolean isCleanupAttempt) {
        String taskDir = "localRunner//" + user + "/" + "jobcache" + "/" + jobid + "/" + taskid;
        if (isCleanupAttempt) {
            taskDir = taskDir + ".cleanup";
        }
        return taskDir;
    }

    static /* synthetic */ HashMap access$000(LocalJobRunner x0) {
        return x0.jobs;
    }

    static /* synthetic */ AtomicInteger access$500(LocalJobRunner x0) {
        return x0.map_tasks;
    }

    static /* synthetic */ LocalJobRunnerMetrics access$600(LocalJobRunner x0) {
        return x0.myMetrics;
    }

    static /* synthetic */ AtomicInteger access$700(LocalJobRunner x0) {
        return x0.reduce_tasks;
    }

    static /* synthetic */ JobConf access$800(LocalJobRunner x0) {
        return x0.conf;
    }

    static /* synthetic */ FileSystem access$900(LocalJobRunner x0) {
        return x0.fs;
    }
}

