/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.mapred.MMCJMRCache;

public class MMCJMRInputCache
extends MMCJMRCache {
    private int cacheSize = 0;
    private boolean flushedAll = false;
    private boolean memOnly;

    public MMCJMRInputCache(JobConf conf, long memSize, long rlen, long clen, int brlen, int bclen, boolean leftCached, Class<? extends MatrixValue> valueClass) throws IOException, IllegalAccessException, InstantiationException {
        long elementSize = 77L + 8L * Math.min(rlen, (long)brlen) * Math.min(clen, (long)bclen) + 20L + 12L + 12L + 4L;
        long numRowBlocks = leftCached ? (long)Math.ceil((double)rlen / (double)brlen) : 1L;
        long numColBlocks = leftCached ? 1L : (long)Math.ceil((double)clen / (double)bclen);
        int buffCapacity = (int)Math.max(Math.min(memSize / elementSize, numRowBlocks * numColBlocks), 1L);
        super.allocateBuffer(buffCapacity, valueClass, false);
        int n = (int)Math.ceil((double)(numRowBlocks * numColBlocks) / (double)this._bufferCapacity);
        boolean bl = this.memOnly = n == 1;
        if (!this.memOnly) {
            this._job = conf;
            this._fs = FileSystem.getLocal(this._job);
            this._fileN = n;
            super.constructLocalFilePrefix("_input_cache_");
            super.deleteAllWorkingFiles();
        }
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void put(long inIndex, MatrixValue inValue) throws Exception {
        if (!this.memOnly) {
            int newFileCursor = this.cacheSize / this._bufferCapacity;
            if (this._fileCursor != -1 && this._fileCursor != newFileCursor) {
                super.writeBuffer();
                this._bufferSize = 0;
            }
            this._fileCursor = newFileCursor;
        }
        int lpos = this.cacheSize % this._bufferCapacity;
        Pair tmp = this._buffer[lpos];
        ((MatrixIndexes)tmp.getKey()).setIndexes(inIndex, inIndex);
        ((MatrixValue)tmp.getValue()).copy(inValue);
        ++this._bufferSize;
        ++this.cacheSize;
    }

    public Pair<MatrixIndexes, MatrixValue> get(int pos) throws IOException {
        int newFileCursor;
        if (!this.memOnly && this._fileCursor != (newFileCursor = pos / this._bufferCapacity)) {
            if (!this.flushedAll) {
                super.writeBuffer();
                this._bufferSize = 0;
                this.flushedAll = true;
            }
            this._fileCursor = newFileCursor;
            super.loadBuffer();
        }
        int lpos = pos % this._bufferCapacity;
        return this._buffer[lpos];
    }

    public void resetCache(boolean fullreset) throws IOException {
        this.cacheSize = 0;
        this.flushedAll = false;
        if (fullreset) {
            this._bufferSize = 0;
        }
        if (!this.memOnly) {
            super.deleteAllWorkingFiles();
        }
    }

    public void close() throws IOException {
        if (!this.memOnly) {
            super.deleteAllWorkingFiles();
        }
    }
}

